/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.postgres;

import com.baremaps.postgres.PostgisRecord;
import com.baremaps.postgres.jdbi.PostgisPlugin;
import java.util.List;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.core.statement.Update;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

class PostgisPluginTest {
    PostgisPluginTest() {
    }

    @Test
    @Tag(value="integration")
    void test() {
        Jdbi jdbi = Jdbi.create((String)"jdbc:tc:postgis:13-3.1:///test").installPlugin((JdbiPlugin)new PostgisPlugin());
        PostgisRecord record = new PostgisRecord();
        record.setId(1);
        record.setPoint(new GeometryFactory().createPoint(new Coordinate(1.0, 1.0)));
        record.setLineString(new GeometryFactory().createLineString(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0), new Coordinate(2.0, 1.0)}));
        record.setPolygon(new GeometryFactory().createPolygon(new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(1.0, 2.0), new Coordinate(2.0, 2.0), new Coordinate(2.0, 1.0), new Coordinate(1.0, 1.0)}));
        List result = (List)jdbi.withHandle(handle -> {
            handle.execute("DROP TABLE IF EXISTS record", new Object[0]);
            handle.execute("CREATE TABLE record (id INTEGER PRIMARY KEY, point geometry(point), linestring geometry(linestring), polygon geometry(polygon))", new Object[0]);
            ((Update)handle.createUpdate("INSERT INTO record (id, point, linestring, polygon) VALUES (:id, :point, :lineString, :polygon)").bindBean((Object)record)).execute();
            return handle.createQuery("SELECT * FROM record ORDER BY id").mapToBean(PostgisRecord.class).list();
        });
        Assertions.assertEquals((Object)record.getPoint(), (Object)((PostgisRecord)result.get(0)).getPoint());
        Assertions.assertEquals((Object)record.getLineString(), (Object)((PostgisRecord)result.get(0)).getLineString());
        Assertions.assertEquals((Object)record.getPolygon(), (Object)((PostgisRecord)result.get(0)).getPolygon());
    }
}

