/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.server;

import com.baremaps.exporter.config.Config;
import com.baremaps.exporter.config.Layer;
import com.baremaps.exporter.config.Style;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class StyleBuilder {
    private final Config config;

    public StyleBuilder(Config config) {
        this.config = config;
    }

    public Map<String, Object> build() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", "baremaps");
        map.put("version", 8);
        map.put("sprite", "");
        map.put("glyphs", "https://daglvzoa8byzd.cloudfront.net/{fontstack}/{range}.pbf");
        map.put("sources", ImmutableSortedMap.naturalOrder().put((Object)"baremaps", (Object)ImmutableSortedMap.naturalOrder().put((Object)"type", (Object)"vector").put((Object)"minZoom", (Object)this.config.getBounds().getMinZoom()).put((Object)"maxZoom", (Object)this.config.getBounds().getMaxZoom()).put((Object)"bounds", (Object)new double[]{this.config.getBounds().getMinLon(), this.config.getBounds().getMinLat(), this.config.getBounds().getMaxLon(), this.config.getBounds().getMaxLat()}).put((Object)"tiles", Arrays.asList(String.format("http://%s:%s/tiles/{z}/{x}/{y}.pbf", this.config.getServer().getHost(), this.config.getServer().getPort()))).build()).build());
        List styles = this.styles().stream().map(style -> {
            TreeMap<String, Object> layer = new TreeMap<String, Object>();
            layer.put("id", style.getId());
            layer.put("source", Optional.ofNullable(style.getSource()).orElse("baremaps"));
            layer.put("source-layer", style.getLayer());
            layer.put("type", style.getType());
            layer.put("minzoom", style.getMinZoom());
            layer.put("maxzoom", style.getMaxZoom());
            layer.put("layout", style.getLayout());
            layer.put("metadata", style.getMetadata());
            layer.put("filter", style.getFilter());
            layer.put("paint", style.getPaint());
            return layer;
        }).collect(Collectors.toList());
        map.put("layers", styles);
        return map;
    }

    private List<Style> styles() {
        if (this.config.getStylesheets().isEmpty()) {
            ArrayList<Style> styles = new ArrayList<Style>();
            styles.add(this.background());
            for (Layer layer : this.config.getLayers()) {
                styles.addAll(this.layerBlueprint(layer));
            }
            return styles;
        }
        List styles = this.config.getStylesheets().stream().flatMap(component -> component.getStyles().stream()).collect(Collectors.toList());
        return Lists.reverse(styles);
    }

    private Style background() {
        Style style = new Style();
        style.setId("background");
        style.setType("background");
        style.setLayout((Object)ImmutableSortedMap.naturalOrder().put((Object)"visibility", (Object)"visible").build());
        style.setPaint((Object)ImmutableSortedMap.naturalOrder().put((Object)"background-color", (Object)"rgb(64, 92, 176)").build());
        return style;
    }

    private List<Style> layerBlueprint(Layer layer) {
        switch (layer.getType()) {
            case "point": {
                return Arrays.asList(this.pointBlueprint(layer, String.format("%s_point", layer.getId())));
            }
            case "line": {
                return Arrays.asList(this.linestringBlueprint(layer, String.format("%s_linestring", layer.getId())));
            }
            case "polygon": {
                return Arrays.asList(this.polygonBlueprint(layer, String.format("%s_polygon", layer.getId())));
            }
            case "geometry": {
                return Arrays.asList(this.pointBlueprint(layer, String.format("%s_point", layer.getId())), this.linestringBlueprint(layer, String.format("%s_linestring", layer.getId())));
            }
        }
        return Arrays.asList(new Style[0]);
    }

    private Style pointBlueprint(Layer layer, String id) {
        Style style = new Style();
        style.setId(id);
        style.setLayer(layer.getId());
        style.setMinZoom(layer.getQueries().stream().mapToInt(q -> q.getMinZoom()).min().getAsInt());
        style.setMaxZoom(layer.getQueries().stream().mapToInt(q -> q.getMaxZoom()).max().getAsInt());
        style.setType("circle");
        style.setLayout((Object)ImmutableSortedMap.naturalOrder().put((Object)"visibility", (Object)"visible").build());
        style.setPaint((Object)ImmutableSortedMap.naturalOrder().put((Object)"circle-color", (Object)"rgba(229, 235, 247, 0.75)").put((Object)"circle-radius", (Object)1).build());
        return style;
    }

    private Style linestringBlueprint(Layer layer, String id) {
        Style style = new Style();
        style.setId(id);
        style.setLayer(layer.getId());
        style.setMinZoom(layer.getQueries().stream().mapToInt(q -> q.getMinZoom()).min().getAsInt());
        style.setMaxZoom(layer.getQueries().stream().mapToInt(q -> q.getMaxZoom()).max().getAsInt());
        style.setType("line");
        style.setLayout((Object)ImmutableSortedMap.naturalOrder().put((Object)"visibility", (Object)"visible").build());
        style.setPaint((Object)ImmutableSortedMap.naturalOrder().put((Object)"line-color", (Object)"rgba(229, 235, 247, 0.50)").put((Object)"line-width", (Object)1).build());
        return style;
    }

    private Style polygonBlueprint(Layer layer, String id) {
        Style style = new Style();
        style.setId(id);
        style.setLayer(layer.getId());
        style.setMinZoom(layer.getQueries().stream().mapToInt(q -> q.getMinZoom()).min().getAsInt());
        style.setMaxZoom(layer.getQueries().stream().mapToInt(q -> q.getMaxZoom()).max().getAsInt());
        style.setType("fill");
        style.setLayout((Object)ImmutableSortedMap.naturalOrder().put((Object)"visibility", (Object)"visible").build());
        style.setPaint((Object)ImmutableSortedMap.naturalOrder().put((Object)"fill-outline-color", (Object)"rgba(229, 235, 247, 0.50)").put((Object)"fill-color", (Object)"rgba(229, 235, 247, 0.25)").put((Object)"fill-antialias", (Object)true).build());
        return style;
    }
}

