/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.server;

import com.baremaps.exporter.store.TileStore;
import com.baremaps.exporter.store.TileStoreException;
import com.baremaps.util.tile.Tile;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileService
extends AbstractHttpService {
    private static Logger logger = LogManager.getLogger();
    private static final ResponseHeaders headers = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", "application/vnd.mapbox-vector-tile").add((CharSequence)"Content-Encoding", "gzip").add((CharSequence)"Access-Control-Allow-Origin", "*").build();
    private final TileStore tileStore;

    public TileService(TileStore tileStore) {
        this.tileStore = tileStore;
    }

    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) {
        int z = Integer.parseInt(ctx.pathParam("z"));
        int x = Integer.parseInt(ctx.pathParam("x"));
        int y = Integer.parseInt(ctx.pathParam("y"));
        Tile tile = new Tile(x, y, z);
        try {
            byte[] bytes = this.tileStore.read(tile);
            if (bytes != null) {
                HttpData data = HttpData.wrap((byte[])bytes);
                return HttpResponse.of((ResponseHeaders)headers, (HttpData)data);
            }
            return HttpResponse.of((int)204);
        }
        catch (TileStoreException ex) {
            logger.error((Object)ex);
            return HttpResponse.of((int)404);
        }
    }
}

