/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.server;

import com.baremaps.exporter.config.Config;
import com.baremaps.exporter.config.Layer;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ConfigBuilder {
    private final Config config;

    public ConfigBuilder(Config config) {
        this.config = config;
    }

    public Map<String, Object> format() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("id", this.config.getId());
        map.put("center", this.config.getCenter());
        map.put("bounds", this.config.getBounds());
        map.put("server", this.config.getServer());
        map.put("layers", this.formatLayers(this.config.getLayers()));
        map.put("stylesheets", this.formatLayers(this.config.getLayers()));
        return map;
    }

    private List<Map<String, Object>> formatLayers(List<Layer> layers) {
        return layers.stream().sorted(Comparator.comparing(Layer::getId)).map(this::formatLayer).collect(Collectors.toList());
    }

    private Map<String, Object> formatLayer(Layer layer) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", layer.getId());
        map.put("queries", layer.getQueries());
        return map;
    }
}

