/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.server;

import com.baremaps.exporter.config.Config;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateService
extends AbstractHttpService {
    private static Logger logger = LoggerFactory.getLogger(TemplateService.class);
    private static final ResponseHeaders headers = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", "application/vnd.mapbox-vector-tile").add((CharSequence)"Content-Encoding", "gzip").add((CharSequence)"Access-Control-Allow-Origin", "*").build();
    public final Supplier<Config> config;

    public TemplateService(Supplier<Config> config) {
        this.config = config;
    }

    protected HttpResponse doGet(ServiceRequestContext ctx, HttpRequest req) throws IOException, TemplateException {
        StringWriter output = new StringWriter();
        Configuration config = new Configuration(Configuration.VERSION_2_3_29);
        config.setLocale(Locale.US);
        config.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "/");
        config.setDefaultEncoding("UTF-8");
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setLogTemplateExceptions(false);
        config.setWrapUncheckedExceptions(true);
        config.setFallbackOnNullLoopVariable(false);
        Template blueprintTemplate = config.getTemplate("index.ftl");
        blueprintTemplate.process((Object)this.config.get(), (Writer)output);
        return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.HTML_UTF_8, (String)output.toString());
    }
}

