/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.editor;

import com.baremaps.config.style.Style;
import com.baremaps.config.tileset.Tileset;
import com.baremaps.tile.Tile;
import com.baremaps.tile.TileStore;
import com.baremaps.tile.TileStoreException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.ProducesJson;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerService {
    private static Logger logger = LoggerFactory.getLogger(ServerService.class);
    private static final ResponseHeaders headers = ResponseHeaders.builder((int)200).add((CharSequence)"Content-Type", "application/vnd.mapbox-vector-tile").add((CharSequence)"Content-Encoding", "gzip").add((CharSequence)"Access-Control-Allow-Origin", "*").build();
    private final String host;
    private final int port;
    private final Tileset tileset;
    private final Style style;
    private final TileStore tileStore;

    public ServerService(String host, int port, Tileset tileset, Style style, TileStore tileStore) {
        this.host = host;
        this.port = port;
        this.tileset = tileset;
        this.style = style;
        this.tileStore = tileStore;
    }

    @Get(value="/style.json")
    @ProducesJson
    public Style getStyle(ServiceRequestContext ctx) throws IOException {
        if (this.tileset.getCenter() != null) {
            this.style.setCenter(List.of(Double.valueOf(this.tileset.getCenter().getLon()), Double.valueOf(this.tileset.getCenter().getLat())));
            this.style.setZoom(Double.valueOf(this.tileset.getCenter().getZoom()));
        }
        InetSocketAddress address = (InetSocketAddress)ctx.localAddress();
        this.style.setSources(Map.of("baremaps", Map.of("type", "vector", "url", String.format("http://%s:%s/tiles.json", this.host, this.port))));
        return this.style;
    }

    @Get(value="/tiles.json")
    @ProducesJson
    public Tileset getTileset(ServiceRequestContext ctx) throws IOException {
        this.tileset.setTiles(Arrays.asList(String.format("http://%s:%s/tiles/{z}/{x}/{y}.mvt", this.host, this.port)));
        return this.tileset;
    }

    @Get(value="regex:^/tiles/(?<z>[0-9]+)/(?<x>[0-9]+)/(?<y>[0-9]+).mvt$")
    @Blocking
    public HttpResponse tile(@Param(value="z") int z, @Param(value="x") int x, @Param(value="y") int y) {
        Tile tile = new Tile(x, y, z);
        try {
            byte[] bytes = this.tileStore.read(tile);
            if (bytes != null) {
                HttpData data = HttpData.wrap((byte[])bytes);
                return HttpResponse.of((ResponseHeaders)headers, (HttpData)data);
            }
            return HttpResponse.of((int)204);
        }
        catch (TileStoreException ex) {
            logger.error(ex.getMessage());
            return HttpResponse.of((int)404);
        }
    }
}

