/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.tile.mbtiles;

import com.baremaps.tile.mbtiles.MBTiles;
import com.baremaps.tile.mbtiles.TileStoreTest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.sqlite.SQLiteDataSource;

class MBTilesTest
extends TileStoreTest {
    MBTilesTest() {
    }

    protected MBTiles createTileStore() throws Exception {
        File file = File.createTempFile("baremaps_", ".db");
        file.deleteOnExit();
        SQLiteDataSource dataSource = new SQLiteDataSource();
        dataSource.setUrl("jdbc:sqlite:" + file.getPath());
        MBTiles tilesStore = new MBTiles(dataSource);
        tilesStore.initializeDatabase();
        return tilesStore;
    }

    @Test
    public void readWriteMetadata() throws Exception {
        MBTiles tileStore = this.createTileStore();
        Map metadata = tileStore.readMetadata();
        Assertions.assertTrue((metadata.size() == 0 ? 1 : 0) != 0);
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("test", "test");
        tileStore.writeMetadata(m1);
        Map m2 = tileStore.readMetadata();
        Assertions.assertTrue((m2.size() == 1 ? 1 : 0) != 0);
        Assertions.assertEquals(m2.get("test"), (Object)"test");
    }
}

