/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.tile.mbtiles;

import com.baremaps.tile.Tile;
import com.baremaps.tile.TileStore;
import com.baremaps.tile.TileStoreException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

public abstract class TileStoreTest {
    @Test
    @Tag(value="integration")
    void readWriteDeleteTile() throws Exception {
        TileStore tileStore = this.createTileStore();
        Tile tile = new Tile(1, 2, 3);
        byte[] content = "tile_content".getBytes();
        tileStore.write(tile, content);
        byte[] bytes = tileStore.read(tile);
        Assertions.assertArrayEquals((byte[])bytes, (byte[])content);
        tileStore.delete(tile);
        Assertions.assertThrows(TileStoreException.class, () -> tileStore.read(tile));
    }

    protected abstract TileStore createTileStore() throws Exception;
}

