/*
 * Decompiled with CFR 0.152.
 */
package com.baremaps.tile.postgres;

import com.baremaps.config.Layer;
import com.baremaps.config.Query;
import com.baremaps.tile.postgres.PostgisQueryParser;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PostgisQueryParserTest {
    private final List<TestQuery> testQueries = ImmutableList.of((Object)new TestQuery(new Query(0, 1, "SELECT id, tags, geom FROM table"), "id", "tags", "geom", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "select id, tags, geom from table"), "id", "tags", "geom", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "SELECT id AS a, tags AS b, geom AS c FROM table"), "id", "tags", "geom", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "select id as a, tags as b, geom as c from table"), "id", "tags", "geom", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "SELECT id, tags, geom FROM table WHERE condition"), "id", "tags", "geom", "table", Optional.of("condition")), (Object)new TestQuery(new Query(0, 1, "SELECT id, tags, geom FROM table WHERE tags ? 'building' AND st_geometrytype(geom) LIKE 'ST_Polygon'"), "id", "tags", "geom", "table", Optional.of("tags ? 'building' AND st_geometrytype(geom) LIKE 'ST_Polygon'")), (Object)new TestQuery(new Query(0, 1, "select id, tags, geom from table where condition"), "id", "tags", "geom", "table", Optional.of("condition")), (Object)new TestQuery(new Query(0, 1, "SELECT id, hstore('tag', tag), geom FROM table"), "id", "hstore('tag', tag)", "geom", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "SELECT id, hstore(array['tag1', 'tag2'], array[tag1, tag2]), geom FROM table"), "id", "hstore(array['tag1', 'tag2'], array[tag1, tag2])", "geom", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "SELECT id, hstore('tag', tag) as tags, geom FROM table"), "id", "hstore('tag', tag)", "geom", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "SELECT id, tags, st_transform(geom, '1234') as geom FROM table"), "id", "tags", "st_transform(geom, '1234')", "table", Optional.empty()), (Object)new TestQuery(new Query(0, 1, "SELECT id, a(b(c), d(e)), geom FROM table"), "id", "a(b(c), d(e))", "geom", "table", Optional.empty()), (Object[])new TestQuery[0]);

    PostgisQueryParserTest() {
    }

    @Test
    void parse() {
        for (TestQuery testQuery : this.testQueries) {
            PostgisQueryParser.Parse q1 = PostgisQueryParser.parse((Layer)new Layer(), (Query)testQuery.query);
            Assertions.assertEquals((Object)q1.getId(), (Object)testQuery.id);
            Assertions.assertEquals((Object)q1.getTags(), (Object)testQuery.tags);
            Assertions.assertEquals((Object)q1.getGeom(), (Object)testQuery.geom);
            Assertions.assertEquals((Object)q1.getFrom(), (Object)testQuery.from);
            Assertions.assertEquals((Object)q1.getWhere(), testQuery.where);
        }
    }

    private class TestQuery {
        public final Query query;
        public final String id;
        public final String tags;
        public final String geom;
        public final String from;
        public final Optional<String> where;

        public TestQuery(Query query, String id, String tags, String geom, String from, Optional<String> where) {
            this.query = query;
            this.id = id;
            this.tags = tags;
            this.geom = geom;
            this.from = from;
            this.where = where;
        }
    }
}

