/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.AttributeKey;
import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.BaseNounPhrase;
import com.basistech.rosette.dm.CategorizerResult;
import com.basistech.rosette.dm.Concept;
import com.basistech.rosette.dm.ConvertFromPreAdm11;
import com.basistech.rosette.dm.Dependency;
import com.basistech.rosette.dm.Embeddings;
import com.basistech.rosette.dm.Entity;
import com.basistech.rosette.dm.EntityMention;
import com.basistech.rosette.dm.Keyphrase;
import com.basistech.rosette.dm.LanguageDetection;
import com.basistech.rosette.dm.ListAttribute;
import com.basistech.rosette.dm.Mention;
import com.basistech.rosette.dm.RelationshipMention;
import com.basistech.rosette.dm.ResolvedEntity;
import com.basistech.rosette.dm.ScriptRegion;
import com.basistech.rosette.dm.Sentence;
import com.basistech.rosette.dm.Token;
import com.basistech.rosette.dm.TranslatedData;
import com.basistech.rosette.dm.TranslatedTokens;
import com.basistech.rosette.dm.TransliterationResults;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableList;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableMap;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import com.basistech.shaded.dm.com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnnotatedText
implements Serializable {
    private static final long serialVersionUID = 222L;
    private final CharSequence data;
    private final Map<String, BaseAttribute> attributes;
    private final Map<String, List<String>> documentMetadata;
    private transient boolean compatMentionsProcessed;
    private transient ListAttribute<EntityMention> compatMentions;
    private transient boolean compatResolvedEntitiesProcessed;
    private transient ListAttribute<ResolvedEntity> compatResolvedEntities;

    AnnotatedText(CharSequence data, Map<String, BaseAttribute> attributes, Map<String, List<String>> documentMetadata, String version) {
        this.data = data;
        this.attributes = this.absorbAttributes(attributes);
        this.documentMetadata = documentMetadata != null ? ImmutableMap.copyOf(documentMetadata) : ImmutableMap.of();
    }

    private Map<String, BaseAttribute> absorbAttributes(Map<String, BaseAttribute> attributes) {
        ImmutableMap.Builder<String, BaseAttribute> builder = new ImmutableMap.Builder<String, BaseAttribute>();
        if (attributes == null) {
            return ImmutableMap.of();
        }
        ListAttribute sourceEntityList = (ListAttribute)attributes.get(AttributeKey.ENTITY.key());
        for (Map.Entry<String, BaseAttribute> me : attributes.entrySet()) {
            if (AttributeKey.RESOLVED_ENTITY.key().equals(me.getKey()) || AttributeKey.ENTITY_MENTION.key().equals(me.getKey()) || AttributeKey.ENTITY.key().equals(me.getKey())) continue;
            builder.put(me);
        }
        ListAttribute oldMentions = (ListAttribute)attributes.get(AttributeKey.ENTITY_MENTION.key());
        ListAttribute oldResolved = (ListAttribute)attributes.get(AttributeKey.RESOLVED_ENTITY.key());
        if (AnnotatedText.anythingInThere(oldResolved) || AnnotatedText.anythingInThere(oldMentions)) {
            ConvertFromPreAdm11.doResolvedConversion(sourceEntityList, oldMentions, oldResolved, builder);
        } else if (sourceEntityList != null) {
            builder.put(AttributeKey.ENTITY.key(), sourceEntityList);
        }
        if (oldResolved != null && oldResolved.size() == 0) {
            this.compatResolvedEntities = new ListAttribute.Builder(ResolvedEntity.class).build();
            this.compatResolvedEntitiesProcessed = true;
        }
        return builder.build();
    }

    private static <T> boolean anythingInThere(List<T> list) {
        return list != null;
    }

    public CharSequence getData() {
        return this.data;
    }

    public Map<String, List<String>> getDocumentMetadata() {
        return this.documentMetadata;
    }

    public Map<String, BaseAttribute> getAttributes() {
        return this.attributes;
    }

    public ListAttribute<Token> getTokens() {
        return (ListAttribute)this.attributes.get(AttributeKey.TOKEN.key());
    }

    public ListAttribute<TranslatedTokens> getTranslatedTokens() {
        return (ListAttribute)this.attributes.get(AttributeKey.TRANSLATED_TOKENS.key());
    }

    public ListAttribute<TranslatedData> getTranslatedData() {
        return (ListAttribute)this.attributes.get(AttributeKey.TRANSLATED_DATA.key());
    }

    public ListAttribute<LanguageDetection> getLanguageDetectionRegions() {
        return (ListAttribute)this.attributes.get(AttributeKey.LANGUAGE_DETECTION_REGIONS.key());
    }

    public LanguageDetection getWholeTextLanguageDetection() {
        return (LanguageDetection)this.attributes.get(AttributeKey.LANGUAGE_DETECTION.key());
    }

    @Deprecated
    public ListAttribute<EntityMention> getEntityMentions() {
        if (!this.compatMentionsProcessed) {
            this.compatMentionsProcessed = true;
            ArrayList<EntityMention> entityMentionList = Lists.newArrayList();
            ListAttribute<Entity> entities = this.getEntities();
            if (entities == null) {
                return null;
            }
            AnnotatedText.downconvertEntities(entityMentionList, entities);
            ListAttribute.Builder<EntityMention> cmListBuilder = new ListAttribute.Builder<EntityMention>(EntityMention.class);
            for (EntityMention entityMention : entityMentionList) {
                cmListBuilder.add(entityMention);
            }
            if (entities.getExtendedProperties() != null) {
                for (Map.Entry entry : entities.getExtendedProperties().entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("mention.")) continue;
                    cmListBuilder.extendedProperty(key.substring(8), entry.getValue());
                }
            }
            this.compatMentions = cmListBuilder.build();
        }
        return this.compatMentions;
    }

    private static void downconvertEntities(List<EntityMention> entityMentionList, ListAttribute<Entity> entities) {
        ArrayList<MentionAndEntity> mentionList = new ArrayList<MentionAndEntity>();
        for (Entity entity : entities) {
            if (entity.getMentions() == null) continue;
            for (Mention mention : entity.getMentions()) {
                mentionList.add(new MentionAndEntity(mention, entity));
            }
        }
        Collections.sort(mentionList, new Comparator<MentionAndEntity>(){

            @Override
            public int compare(MentionAndEntity o1, MentionAndEntity o2) {
                if (o1.mention.getStartOffset() == o2.mention.getStartOffset()) {
                    return o1.mention.getEndOffset() - o2.mention.getEndOffset();
                }
                return o1.mention.getStartOffset() - o2.mention.getStartOffset();
            }
        });
        HashMap<Mention, Integer> mentionOrdinals = new HashMap<Mention, Integer>();
        for (int x = 0; x < mentionList.size(); ++x) {
            mentionOrdinals.put(((MentionAndEntity)mentionList.get((int)x)).mention, x);
        }
        for (MentionAndEntity mae : mentionList) {
            Mention mention;
            mention = mae.mention;
            Entity entity = mae.entity;
            String type = (String)mention.getExtendedProperties().get("old-entity-type");
            if (type == null) {
                type = entity.getType();
            }
            EntityMention.Builder emBuilder = new EntityMention.Builder(mention.getStartOffset(), mention.getEndOffset(), type);
            if (entity.getHeadMentionIndex() != null) {
                emBuilder.coreferenceChainId((Integer)mentionOrdinals.get(entity.getMentions().get(entity.getHeadMentionIndex())));
            }
            if (mention.getConfidence() != null) {
                emBuilder.confidence(mention.getConfidence());
            }
            if (mention.getLinkingConfidence() != null) {
                emBuilder.linkingConfidence(mention.getLinkingConfidence());
            }
            if (mention.getExtendedProperties() != null && mention.getExtendedProperties().size() > 0) {
                for (Map.Entry<String, Object> me : mention.getExtendedProperties().entrySet()) {
                    if (me.getKey().equals("old-entity-type")) continue;
                    if (me.getKey().equals("oldFlags")) {
                        emBuilder.flags((Integer)me.getValue());
                        continue;
                    }
                    if (me.getKey().equals("oldCoreferenceChainId")) continue;
                    emBuilder.extendedProperty(me.getKey(), me.getValue());
                }
            }
            if (mention.getNormalized() != null) {
                emBuilder.normalized(mention.getNormalized());
            }
            if (mention.getSource() != null) {
                emBuilder.source(mention.getSource());
            }
            if (mention.getSubsource() != null) {
                emBuilder.subsource(mention.getSubsource());
            }
            entityMentionList.add(emBuilder.build());
        }
    }

    public ListAttribute<Entity> getEntities() {
        return (ListAttribute)this.attributes.get(AttributeKey.ENTITY.key());
    }

    public ListAttribute<RelationshipMention> getRelationshipMentions() {
        return (ListAttribute)this.attributes.get(AttributeKey.RELATIONSHIP_MENTION.key());
    }

    @Deprecated
    public ListAttribute<ResolvedEntity> getResolvedEntities() {
        if (!this.compatResolvedEntitiesProcessed) {
            this.compatResolvedEntitiesProcessed = true;
            ListAttribute.Builder<ResolvedEntity> reListBuilder = new ListAttribute.Builder<ResolvedEntity>(ResolvedEntity.class);
            ListAttribute<Entity> entities = this.getEntities();
            if (entities == null) {
                return null;
            }
            if (entities.getExtendedProperties() != null) {
                for (Map.Entry entry : entities.getExtendedProperties().entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.startsWith("mention.")) continue;
                    reListBuilder.extendedProperty(key, entry.getValue());
                }
            }
            for (Entity entity : entities) {
                if (entity.getHeadMentionIndex() == null) continue;
                int headStart = 0;
                int headEnd = 0;
                if (entity.getHeadMentionIndex() != null) {
                    Mention head = entity.getMentions().get(entity.getHeadMentionIndex());
                    headStart = head.getStartOffset();
                    headEnd = head.getEndOffset();
                }
                ResolvedEntity.Builder reBuilder = new ResolvedEntity.Builder(headStart, headEnd, entity.getEntityId());
                if (entity.getConfidence() != null) {
                    reBuilder.confidence(entity.getConfidence());
                }
                if (entity.getSentiment() != null && !entity.getSentiment().isEmpty()) {
                    reBuilder.sentiment(entity.getSentiment().get(0));
                }
                if (entity.getExtendedProperties() != null) {
                    for (Map.Entry<String, Object> me : entity.getExtendedProperties().entrySet()) {
                        if (me.getKey().equals("oldCoreferenceChainId")) {
                            reBuilder.coreferenceChainId((Integer)me.getValue());
                            continue;
                        }
                        reBuilder.extendedProperty(me.getKey(), me.getValue());
                    }
                }
                reListBuilder.add(reBuilder.build());
            }
            this.compatResolvedEntities = reListBuilder.build();
            if (this.compatResolvedEntities.size() == 0) {
                this.compatResolvedEntities = null;
            }
        }
        return this.compatResolvedEntities;
    }

    public ListAttribute<ScriptRegion> getScriptRegions() {
        return (ListAttribute)this.attributes.get(AttributeKey.SCRIPT_REGION.key());
    }

    public ListAttribute<Sentence> getSentences() {
        return (ListAttribute)this.attributes.get(AttributeKey.SENTENCE.key());
    }

    public ListAttribute<BaseNounPhrase> getBaseNounPhrases() {
        return (ListAttribute)this.attributes.get(AttributeKey.BASE_NOUN_PHRASE.key());
    }

    public ListAttribute<CategorizerResult> getCategorizerResults() {
        return (ListAttribute)this.attributes.get(AttributeKey.CATEGORIZER_RESULTS.key());
    }

    public ListAttribute<CategorizerResult> getSentimentResults() {
        return (ListAttribute)this.attributes.get(AttributeKey.SENTIMENT_RESULTS.key());
    }

    public ListAttribute<Dependency> getDependencies() {
        return (ListAttribute)this.attributes.get(AttributeKey.DEPENDENCY.key());
    }

    public ListAttribute<CategorizerResult> getTopicResults() {
        return (ListAttribute)this.attributes.get(AttributeKey.TOPIC_RESULTS.key());
    }

    public Embeddings getEmbeddings() {
        return (Embeddings)this.attributes.get(AttributeKey.EMBEDDING.key());
    }

    public ListAttribute<Concept> getConcepts() {
        return (ListAttribute)this.attributes.get(AttributeKey.CONCEPT.key());
    }

    public ListAttribute<Keyphrase> getKeyphrases() {
        return (ListAttribute)this.attributes.get(AttributeKey.KEYPHRASE.key());
    }

    public TransliterationResults getTransliteration() {
        return (TransliterationResults)this.attributes.get(AttributeKey.TRANSLITERATION.key());
    }

    public String toString() {
        if (this.data == null) {
            return null;
        }
        return this.data.toString();
    }

    public static class Builder {
        private CharSequence data;
        private final Map<String, BaseAttribute> attributes = Maps.newHashMap();
        private final Map<String, List<String>> documentMetadata = Maps.newHashMap();

        public Builder() {
        }

        public Builder(AnnotatedText startingPoint) {
            this.data = startingPoint.data;
            this.attributes.putAll(startingPoint.attributes);
            this.documentMetadata.putAll(startingPoint.documentMetadata);
        }

        public Builder data(CharSequence data) {
            this.data = data;
            return this;
        }

        public CharSequence data() {
            return this.data;
        }

        public Builder baseNounPhrases(ListAttribute<BaseNounPhrase> baseNounPhrases) {
            this.attributes.put(AttributeKey.BASE_NOUN_PHRASE.key(), baseNounPhrases);
            return this;
        }

        @Deprecated
        public Builder entityMentions(ListAttribute<EntityMention> entityMentions) {
            this.attributes.remove(AttributeKey.ENTITY.key());
            this.attributes.put(AttributeKey.ENTITY_MENTION.key(), entityMentions);
            return this;
        }

        public Builder relationshipMentions(ListAttribute<RelationshipMention> relationshipMentions) {
            this.attributes.put(AttributeKey.RELATIONSHIP_MENTION.key(), relationshipMentions);
            return this;
        }

        public Builder entities(ListAttribute<Entity> entities) {
            this.attributes.remove(AttributeKey.ENTITY_MENTION.key());
            this.attributes.remove(AttributeKey.RESOLVED_ENTITY.key());
            this.attributes.put(AttributeKey.ENTITY.key(), entities);
            return this;
        }

        @Deprecated
        public Builder resolvedEntities(ListAttribute<ResolvedEntity> resolvedEntities) {
            if (resolvedEntities != null && !resolvedEntities.isEmpty()) {
                if (this.attributes.containsKey(AttributeKey.ENTITY.key())) {
                    ArrayList<EntityMention> oldList = Lists.newArrayList();
                    AnnotatedText.downconvertEntities(oldList, (ListAttribute)this.attributes.get(AttributeKey.ENTITY.key()));
                    ListAttribute.Builder<EntityMention> oldBuilder = new ListAttribute.Builder<EntityMention>(EntityMention.class);
                    for (EntityMention em : oldList) {
                        oldBuilder.add(em);
                    }
                    this.attributes.remove(AttributeKey.ENTITY.key());
                    this.attributes.put(AttributeKey.ENTITY_MENTION.key(), oldBuilder.build());
                }
                this.attributes.put(AttributeKey.RESOLVED_ENTITY.key(), resolvedEntities);
            }
            return this;
        }

        public Builder languageDetectionRegions(ListAttribute<LanguageDetection> languageDetectionRegions) {
            this.attributes.put(AttributeKey.LANGUAGE_DETECTION_REGIONS.key(), languageDetectionRegions);
            return this;
        }

        public Builder wholeDocumentLanguageDetection(LanguageDetection languageDetection) {
            this.attributes.put(AttributeKey.LANGUAGE_DETECTION.key(), languageDetection);
            return this;
        }

        public Builder scriptRegions(ListAttribute<ScriptRegion> scriptRegions) {
            this.attributes.put(AttributeKey.SCRIPT_REGION.key(), scriptRegions);
            return this;
        }

        public Builder sentences(ListAttribute<Sentence> sentences) {
            this.attributes.put(AttributeKey.SENTENCE.key(), sentences);
            return this;
        }

        public Builder tokens(ListAttribute<Token> tokens) {
            this.attributes.put(AttributeKey.TOKEN.key(), tokens);
            return this;
        }

        public Builder translatedTokens(ListAttribute<TranslatedTokens> translatedTokens) {
            this.attributes.put(AttributeKey.TRANSLATED_TOKENS.key(), translatedTokens);
            return this;
        }

        public Builder translatedData(ListAttribute<TranslatedData> translatedData) {
            this.attributes.put(AttributeKey.TRANSLATED_DATA.key(), translatedData);
            return this;
        }

        public Builder categorizerResults(ListAttribute<CategorizerResult> categorizerResults) {
            this.attributes.put(AttributeKey.CATEGORIZER_RESULTS.key(), categorizerResults);
            return this;
        }

        public Builder sentimentResults(ListAttribute<CategorizerResult> sentimentResults) {
            this.attributes.put(AttributeKey.SENTIMENT_RESULTS.key(), sentimentResults);
            return this;
        }

        public Builder dependencies(ListAttribute<Dependency> dependencies) {
            this.attributes.put(AttributeKey.DEPENDENCY.key(), dependencies);
            return this;
        }

        public Builder topicResults(ListAttribute<CategorizerResult> topicResults) {
            this.attributes.put(AttributeKey.TOPIC_RESULTS.key(), topicResults);
            return this;
        }

        public Builder embeddings(Embeddings embeddings) {
            this.attributes.put(AttributeKey.EMBEDDING.key(), embeddings);
            return this;
        }

        public Builder concepts(ListAttribute<Concept> concepts) {
            this.attributes.put(AttributeKey.CONCEPT.key(), concepts);
            return this;
        }

        public Builder keyphrases(ListAttribute<Keyphrase> keyphrases) {
            this.attributes.put(AttributeKey.KEYPHRASE.key(), keyphrases);
            return this;
        }

        public Builder transliteration(TransliterationResults transliterationResults) {
            this.attributes.put(AttributeKey.TRANSLITERATION.key(), transliterationResults);
            return this;
        }

        Builder attribute(String key, BaseAttribute attribute) {
            this.attributes.put(key, attribute);
            return this;
        }

        Builder attribute(AttributeKey key, BaseAttribute attribute) {
            this.attributes.put(key.key(), attribute);
            return this;
        }

        public Map<String, BaseAttribute> attributes() {
            return this.attributes;
        }

        public Builder documentMetadata(String key, List<String> value) {
            this.documentMetadata.put(key, ImmutableList.copyOf(value));
            return this;
        }

        public Builder documentMetadata(Map<String, List<String>> mapOfValues) {
            for (Map.Entry<String, List<String>> me : mapOfValues.entrySet()) {
                this.documentMetadata.put(me.getKey(), ImmutableList.copyOf((Collection)me.getValue()));
            }
            return this;
        }

        public Builder documentMetadata(String key, String value) {
            this.documentMetadata.put(key, Lists.newArrayList(value));
            return this;
        }

        public Map<String, List<String>> documentMetadata() {
            return this.documentMetadata;
        }

        public AnnotatedText build() {
            return new AnnotatedText(this.data, this.attributes, this.documentMetadata, null);
        }
    }

    private static class MentionAndEntity {
        final Mention mention;
        final Entity entity;

        MentionAndEntity(Mention mention, Entity entity) {
            this.mention = mention;
            this.entity = entity;
        }
    }
}

