/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class Concept
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 222L;
    private final String phrase;
    private final Double salience;
    private final String conceptId;

    protected Concept(String phrase, Double salience, String conceptId, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.phrase = phrase;
        this.salience = salience;
        this.conceptId = conceptId;
    }

    public String getPhrase() {
        return this.phrase;
    }

    public Double getSalience() {
        return this.salience;
    }

    public String getConceptId() {
        return this.conceptId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Concept that = (Concept)o;
        return Objects.equals(this.phrase, that.phrase) && Objects.equals(this.salience, that.salience) && Objects.equals(this.conceptId, that.conceptId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.phrase, this.salience, this.conceptId);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("phrase", this.phrase).add("salience", this.salience).add("conceptId", this.conceptId);
    }

    public static class Builder
    extends BaseAttribute.Builder<Concept, Builder> {
        protected String phrase;
        protected Double salience;
        protected String conceptId;

        public Builder(String phrase, String conceptId) {
            this.phrase = phrase;
            this.conceptId = conceptId;
        }

        public Builder(Concept toCopy) {
            super(toCopy);
            this.phrase = toCopy.getPhrase();
            this.salience = toCopy.getSalience();
            this.conceptId = toCopy.getConceptId();
        }

        public Builder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public Builder salience(Double salience) {
            this.salience = salience;
            return this;
        }

        public Builder conceptId(String conceptId) {
            this.conceptId = conceptId;
            return this;
        }

        public Concept build() {
            return new Concept(this.phrase, this.salience, this.conceptId, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

