/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.CategorizerResult;
import com.basistech.rosette.dm.Mention;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Entity
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 222L;
    private List<Mention> mentions;
    private final Integer headMentionIndex;
    private final String type;
    private final String entityId;
    private final Double confidence;
    private final List<CategorizerResult> sentiment;
    private final Double salience;

    protected Entity(List<Mention> mentions, Integer headMentionIndex, String type, String entityId, Double confidence, List<CategorizerResult> sentiment, Double salience, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.mentions = Entity.listOrNull(mentions);
        this.headMentionIndex = headMentionIndex;
        this.type = type;
        this.entityId = entityId;
        this.confidence = confidence;
        this.sentiment = Entity.listOrNull(sentiment);
        this.salience = salience;
    }

    public String getEntityId() {
        return this.entityId;
    }

    public List<Mention> getMentions() {
        return this.mentions;
    }

    public Integer getHeadMentionIndex() {
        return this.headMentionIndex;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public List<CategorizerResult> getSentiment() {
        return this.sentiment;
    }

    public String getType() {
        return this.type;
    }

    public Double getSalience() {
        return this.salience;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Entity entity = (Entity)o;
        return Objects.equals(this.mentions, entity.mentions) && Objects.equals(this.headMentionIndex, entity.headMentionIndex) && Objects.equals(this.type, entity.type) && Objects.equals(this.entityId, entity.entityId) && Objects.equals(this.confidence, entity.confidence) && Objects.equals(this.sentiment, entity.sentiment) && Objects.equals(this.salience, entity.salience);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mentions, this.headMentionIndex, this.type, this.entityId, this.confidence, this.sentiment, this.salience);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("type", this.type).add("entityId", this.entityId).add("mentions", this.mentions).add("confidence", this.confidence).add("sentiment", this.sentiment).add("salience", this.salience);
    }

    public static class Builder
    extends BaseAttribute.Builder<Entity, Builder> {
        private String entityId;
        private String type;
        private List<Mention> mentions = Lists.newArrayList();
        private Integer headMentionIndex;
        private Double confidence;
        private List<CategorizerResult> sentiment;
        private Double salience;

        public Builder() {
            this.sentiment = Lists.newArrayList();
        }

        public Builder(Entity toCopy) {
            super(toCopy);
            Builder.addAllToList(this.mentions, toCopy.mentions);
            this.entityId = toCopy.entityId;
            this.confidence = toCopy.confidence;
            this.sentiment = Lists.newArrayList();
            Builder.addAllToList(this.sentiment, toCopy.sentiment);
            this.type = toCopy.type;
            this.headMentionIndex = toCopy.headMentionIndex;
            this.salience = toCopy.salience;
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public Builder mention(Mention mention) {
            this.mentions.add(mention);
            return this;
        }

        public Builder headMentionIndex(Integer headMentionIndex) {
            this.headMentionIndex = headMentionIndex;
            return this;
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder sentiment(CategorizerResult sentiment) {
            this.sentiment.add(sentiment);
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder salience(Double salience) {
            this.salience = salience;
            return this;
        }

        public Entity build() {
            return new Entity(this.mentions, this.headMentionIndex, this.type, this.entityId, this.confidence, this.sentiment, this.salience, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

