/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.Extent;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class Keyphrase
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 222L;
    private final String phrase;
    private final Double salience;
    private final List<Extent> extents;

    protected Keyphrase(String phrase, Double salience, List<Extent> extents, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.phrase = phrase;
        this.salience = salience;
        this.extents = Keyphrase.listOrNull(extents);
    }

    public String getPhrase() {
        return this.phrase;
    }

    public Double getSalience() {
        return this.salience;
    }

    public List<Extent> getExtents() {
        return this.extents;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("phrase", this.phrase).add("salience", this.salience).add("extents", this.extents);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Keyphrase that = (Keyphrase)o;
        if (this.phrase != null ? !this.phrase.equals(that.phrase) : that.phrase != null) {
            return false;
        }
        if (this.salience != null ? !this.salience.equals(that.salience) : that.salience != null) {
            return false;
        }
        return !(this.extents == null ? that.extents != null : !this.extents.equals(that.extents));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.phrase != null ? this.phrase.hashCode() : 0);
        result = 31 * result + (this.salience != null ? this.salience.hashCode() : 0);
        result = 31 * result + (this.extents != null ? this.extents.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends BaseAttribute.Builder<Keyphrase, Builder> {
        private String phrase;
        private Double salience;
        private List<Extent> extents;

        public Builder(String phrase, List<Extent> extents) {
            this.phrase = phrase;
            this.extents = extents;
        }

        public Builder(Keyphrase toCopy) {
            super(toCopy);
            this.phrase = toCopy.getPhrase();
            this.salience = toCopy.getSalience();
            this.extents = toCopy.getExtents();
        }

        public Builder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public Builder salience(Double salience) {
            this.salience = salience;
            return this;
        }

        public Builder extents(List<Extent> extents) {
            this.extents = extents;
            return this;
        }

        public Keyphrase build() {
            return new Keyphrase(this.phrase, this.salience, this.extents, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

