/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.MorphoAnalysis;
import com.basistech.rosette.dm.Token;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class KoreanMorphoAnalysis
extends MorphoAnalysis
implements Serializable {
    private static final long serialVersionUID = 222L;
    private final List<String> morphemes;
    private final List<String> morphemeTags;

    protected KoreanMorphoAnalysis(String partOfSpeech, String lemma, List<Token> components, String raw, List<String> morphemes, List<String> morphemeTags, Map<String, Object> extendedProperties) {
        super(partOfSpeech, lemma, components, raw, extendedProperties);
        this.morphemes = KoreanMorphoAnalysis.listOrNull(morphemes);
        this.morphemeTags = KoreanMorphoAnalysis.listOrNull(morphemeTags);
    }

    public List<String> getMorphemes() {
        return this.morphemes;
    }

    public List<String> getMorphemeTags() {
        return this.morphemeTags;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KoreanMorphoAnalysis that = (KoreanMorphoAnalysis)o;
        if (this.morphemeTags != null ? !this.morphemeTags.equals(that.morphemeTags) : that.morphemeTags != null) {
            return false;
        }
        return !(this.morphemes == null ? that.morphemes != null : !this.morphemes.equals(that.morphemes));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.morphemes != null ? this.morphemes.hashCode() : 0);
        result = 31 * result + (this.morphemeTags != null ? this.morphemeTags.hashCode() : 0);
        return result;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("morphemes", this.morphemes).add("morphemeTags", this.morphemeTags);
    }

    public static class Builder
    extends MorphoAnalysis.Builder<KoreanMorphoAnalysis, Builder> {
        private List<String> morphemes = Lists.newArrayList();
        private List<String> morphemeTags = Lists.newArrayList();

        public Builder() {
        }

        public Builder(KoreanMorphoAnalysis toCopy) {
            super(toCopy);
            Builder.addAllToList(this.morphemes, toCopy.getMorphemes());
            Builder.addAllToList(this.morphemeTags, toCopy.getMorphemeTags());
        }

        public Builder addMorpheme(String morpheme, String tag) {
            this.morphemes.add(morpheme);
            this.morphemeTags.add(tag);
            return this;
        }

        public Builder morphemes(List<String> morphemes, List<String> morphemeTags) {
            this.morphemes = Builder.nullOrList(morphemes);
            this.morphemeTags = Builder.nullOrList(morphemeTags);
            return this;
        }

        @Override
        public KoreanMorphoAnalysis build() {
            return new KoreanMorphoAnalysis(this.partOfSpeech, this.lemma, this.components, this.raw, this.morphemes, this.morphemeTags, this.buildExtendedProperties());
        }
    }
}

