/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableList;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ListAttribute<Item extends BaseAttribute>
extends BaseAttribute
implements List<Item>,
Serializable {
    private static final long serialVersionUID = 222L;
    private final List<Item> items;
    private final Class<? extends BaseAttribute> itemClass;

    protected ListAttribute(Class<? extends BaseAttribute> itemClass, List<Item> items) {
        this.itemClass = itemClass;
        this.items = ImmutableList.copyOf(items);
    }

    protected ListAttribute(Class<? extends BaseAttribute> itemClass, List<Item> items, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.items = items;
        this.itemClass = itemClass;
    }

    public List<Item> getItems() {
        return this.items;
    }

    @Override
    public boolean equals(Object o) {
        return this.items.equals(o);
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    public Class<? extends BaseAttribute> getItemClass() {
        return this.itemClass;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    @Override
    public Iterator<Item> iterator() {
        return this.items.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.items.toArray(a);
    }

    @Override
    public boolean add(Item item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.items.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Item> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Item> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item get(int index) {
        return (Item)((BaseAttribute)this.items.get(index));
    }

    @Override
    public Item set(int index, Item element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Item element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Item remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    @Override
    public ListIterator<Item> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator<Item> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public List<Item> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper(this).add("items", this.items).add("itemClass", this.itemClass);
    }

    public static class Builder<Item extends BaseAttribute>
    extends BaseAttribute.Builder<ListAttribute<Item>, Builder<Item>> {
        private Class<? extends BaseAttribute> itemClass;
        private List<Item> items;

        public Builder(Class<? extends BaseAttribute> itemClass) {
            this.itemClass = itemClass;
            this.items = Lists.newArrayList();
        }

        public Builder<Item> add(Item item) {
            this.items.add(item);
            return this;
        }

        public Builder<Item> setItems(List<Item> items) {
            this.items.addAll(items);
            return this;
        }

        public ListAttribute<Item> build() {
            return new ListAttribute<Item>(this.itemClass, this.items, this.buildExtendedProperties());
        }

        @Override
        protected Builder<Item> getThis() {
            return this;
        }
    }
}

