/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.Attribute;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Map;

public class Mention
extends Attribute
implements Serializable {
    private static final long serialVersionUID = 222L;
    private final Double confidence;
    private final Double linkingConfidence;
    private final String source;
    private final String subsource;
    private final String normalized;

    protected Mention(int startOffset, int endOffset, Double confidence, Double linkingConfidence, String source, String subsource, String normalized, Map<String, Object> extendedProperties) {
        super(startOffset, endOffset, extendedProperties);
        this.confidence = confidence;
        this.linkingConfidence = linkingConfidence;
        this.source = source;
        this.subsource = subsource;
        this.normalized = normalized;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public Double getLinkingConfidence() {
        return this.linkingConfidence;
    }

    public String getSource() {
        return this.source;
    }

    public String getSubsource() {
        return this.subsource;
    }

    public String getNormalized() {
        return this.normalized;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Mention that = (Mention)o;
        if (this.confidence != null ? !this.confidence.equals(that.confidence) : that.confidence != null) {
            return false;
        }
        if (this.linkingConfidence != null ? !this.linkingConfidence.equals(that.linkingConfidence) : that.linkingConfidence != null) {
            return false;
        }
        if (this.normalized != null ? !this.normalized.equals(that.normalized) : that.normalized != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.subsource == null ? that.subsource != null : !this.subsource.equals(that.subsource));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.confidence != null ? this.confidence.hashCode() : 0);
        result = 31 * result + (this.linkingConfidence != null ? this.linkingConfidence.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.subsource != null ? this.subsource.hashCode() : 0);
        result = 31 * result + (this.normalized != null ? this.normalized.hashCode() : 0);
        return result;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("confidence", this.confidence).add("linkingConfidence", this.linkingConfidence).add("source", this.source).add("subsource", this.subsource).add("normalized", this.normalized);
    }

    public static class Builder
    extends Attribute.Builder<Mention, Builder> {
        private Double confidence;
        private Double linkingConfidence;
        private String source;
        private String subsource;
        private String normalized;

        public Builder(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        public Builder(Mention toCopy) {
            super(toCopy);
            this.confidence = toCopy.confidence;
            this.source = toCopy.source;
            this.subsource = toCopy.subsource;
            this.normalized = toCopy.normalized;
            this.linkingConfidence = toCopy.linkingConfidence;
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder linkingConfidence(Double linkingConfidence) {
            this.linkingConfidence = linkingConfidence;
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder subsource(String subsource) {
            this.subsource = subsource;
            return this;
        }

        public Builder normalized(String normalized) {
            this.normalized = normalized;
            return this;
        }

        public Mention build() {
            return new Mention(this.startOffset, this.endOffset, this.confidence, this.linkingConfidence, this.source, this.subsource, this.normalized, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

