/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.Extent;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import com.basistech.shaded.dm.com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class RelationshipComponent
extends BaseAttribute
implements Serializable {
    private static final long serialVersionUID = 222L;
    private final String phrase;
    private final List<Extent> extents;
    private final String identifier;

    protected RelationshipComponent(String phrase, List<Extent> extents, String identifier, Map<String, Object> extendedProperties) {
        super(extendedProperties);
        this.phrase = phrase;
        this.identifier = identifier;
        this.extents = RelationshipComponent.listOrNull(extents);
    }

    public String getPhrase() {
        return this.phrase;
    }

    public List<Extent> getExtents() {
        return this.extents;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("phrase", this.phrase).add("extents", this.extents).add("identifier", this.identifier);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationshipComponent that = (RelationshipComponent)o;
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.phrase != null ? !this.phrase.equals(that.phrase) : that.phrase != null) {
            return false;
        }
        return !(this.extents == null ? that.extents != null : !this.extents.equals(that.extents));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.phrase.hashCode();
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.extents != null ? this.extents.hashCode() : 0);
        return result;
    }

    public static class Builder
    extends BaseAttribute.Builder<RelationshipComponent, Builder> {
        private String phrase;
        private String identifier;
        private List<Extent> extents = Lists.newArrayList();

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder phrase(String phrase) {
            this.phrase = phrase;
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder extents(List<Extent> extents) {
            this.extents = extents;
            return this;
        }

        public RelationshipComponent build() {
            return new RelationshipComponent(this.phrase, this.extents, this.identifier, this.buildExtendedProperties());
        }
    }
}

