/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.Attribute;
import com.basistech.rosette.dm.RelationshipComponent;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class RelationshipMention
extends Attribute
implements Serializable {
    private static final long serialVersionUID = 222L;
    private final RelationshipComponent predicate;
    private final RelationshipComponent arg1;
    private final RelationshipComponent arg2;
    private final RelationshipComponent arg3;
    private final Set<RelationshipComponent> adjuncts;
    private final Set<RelationshipComponent> locatives;
    private final Set<RelationshipComponent> temporals;
    private final String source;
    private final Double confidence;
    private final Set<String> modality;
    private final Double salience;

    protected RelationshipMention(int startOffset, int endOffset, RelationshipComponent predicate, RelationshipComponent arg1, RelationshipComponent arg2, RelationshipComponent arg3, Set<RelationshipComponent> adjuncts, Set<RelationshipComponent> locatives, Set<RelationshipComponent> temporals, String source, Double confidence, Set<String> modality, Double salience, Map<String, Object> extendedProperties) {
        super(startOffset, endOffset, extendedProperties);
        this.source = source;
        this.confidence = confidence;
        this.predicate = predicate;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.adjuncts = RelationshipMention.setOrNull(adjuncts);
        this.locatives = RelationshipMention.setOrNull(locatives);
        this.temporals = RelationshipMention.setOrNull(temporals);
        this.modality = RelationshipMention.setOrNull(modality);
        this.salience = salience;
    }

    public RelationshipComponent getPredicate() {
        return this.predicate;
    }

    public RelationshipComponent getArg1() {
        return this.arg1;
    }

    public RelationshipComponent getArg2() {
        return this.arg2;
    }

    public RelationshipComponent getArg3() {
        return this.arg3;
    }

    public Set<RelationshipComponent> getAdjuncts() {
        return this.adjuncts;
    }

    public Set<RelationshipComponent> getLocatives() {
        return this.locatives;
    }

    public Set<RelationshipComponent> getTemporals() {
        return this.temporals;
    }

    public String getSource() {
        return this.source;
    }

    public Double getConfidence() {
        return this.confidence;
    }

    public boolean hasSyntheticPredicate() {
        return this.predicate.getExtents() == null || this.predicate.getExtents().isEmpty();
    }

    public Set<String> getModality() {
        return this.modality;
    }

    public Double getSalience() {
        return this.salience;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("predicate", this.predicate).add("arg1", this.arg1).add("arg2", this.arg2).add("arg3", this.arg3).add("adjuncts", this.adjuncts).add("locatives", this.locatives).add("temporals", this.temporals).add("source", this.source).add("confidence", this.confidence).add("salience", this.salience).add("modality", this.modality);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RelationshipMention that = (RelationshipMention)o;
        return Objects.equals(this.predicate, that.predicate) && Objects.equals(this.arg1, that.arg1) && Objects.equals(this.arg2, that.arg2) && Objects.equals(this.arg3, that.arg3) && Objects.equals(this.adjuncts, that.adjuncts) && Objects.equals(this.locatives, that.locatives) && Objects.equals(this.temporals, that.temporals) && Objects.equals(this.source, that.source) && Objects.equals(this.confidence, that.confidence) && Objects.equals(this.modality, that.modality) && Objects.equals(this.salience, that.salience);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predicate, this.arg1, this.arg2, this.arg3, this.adjuncts, this.locatives, this.temporals, this.source, this.confidence, this.modality, this.salience);
    }

    public static class Builder
    extends Attribute.Builder<RelationshipMention, Builder> {
        private RelationshipComponent predicate;
        private RelationshipComponent arg1;
        private RelationshipComponent arg2;
        private RelationshipComponent arg3;
        private Set<RelationshipComponent> adjuncts = new HashSet<RelationshipComponent>();
        private Set<RelationshipComponent> locatives = new HashSet<RelationshipComponent>();
        private Set<RelationshipComponent> temporals = new HashSet<RelationshipComponent>();
        private String source;
        private Double confidence;
        private Set<String> modality;
        private Double salience;

        public Builder(int startOffset, int endOffset) {
            super(startOffset, endOffset);
        }

        public Builder(RelationshipMention toCopy) {
            super(toCopy);
            this.predicate = toCopy.predicate;
            this.arg1 = toCopy.arg1;
            this.arg2 = toCopy.arg2;
            this.arg3 = toCopy.arg3;
            Builder.addAllToSet(this.adjuncts, toCopy.adjuncts);
            Builder.addAllToSet(this.locatives, toCopy.locatives);
            Builder.addAllToSet(this.temporals, toCopy.temporals);
            this.source = toCopy.source;
            this.confidence = toCopy.confidence;
            this.modality = toCopy.modality;
            this.salience = toCopy.salience;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder extendedProperty(String key, Object value) {
            super.extendedProperty(key, value);
            return this;
        }

        public Builder predicate(RelationshipComponent predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder arg1(RelationshipComponent arg1) {
            this.arg1 = arg1;
            return this;
        }

        public Builder arg2(RelationshipComponent arg2) {
            this.arg2 = arg2;
            return this;
        }

        public Builder arg3(RelationshipComponent arg3) {
            this.arg3 = arg3;
            return this;
        }

        public Builder adjuncts(Set<RelationshipComponent> adjuncts) {
            this.adjuncts = new HashSet<RelationshipComponent>();
            Builder.addAllToSet(this.adjuncts, adjuncts);
            return this;
        }

        public Builder addAdjunct(RelationshipComponent adjunct) {
            this.adjuncts.add(adjunct);
            return this;
        }

        public Builder locatives(Set<RelationshipComponent> locatives) {
            this.locatives = new HashSet<RelationshipComponent>();
            Builder.addAllToSet(this.locatives, locatives);
            return this;
        }

        public Builder addLocative(RelationshipComponent locative) {
            this.locatives.add(locative);
            return this;
        }

        public Builder temporals(Set<RelationshipComponent> temporals) {
            this.temporals = new HashSet<RelationshipComponent>();
            Builder.addAllToSet(this.temporals, temporals);
            return this;
        }

        public Builder addTemporal(RelationshipComponent temporal) {
            this.temporals.add(temporal);
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            return this;
        }

        public Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public Builder modality(Set<String> modality) {
            this.modality = new HashSet<String>();
            this.modality.addAll(modality);
            return this;
        }

        public Builder salience(Double salience) {
            this.salience = salience;
            return this;
        }

        public RelationshipMention build() {
            return new RelationshipMention(this.startOffset, this.endOffset, this.predicate, this.arg1, this.arg2, this.arg3, this.adjuncts, this.locatives, this.temporals, this.source, this.confidence, this.modality, this.salience, this.buildExtendedProperties());
        }
    }
}

