/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.shaded.dm.com.google.common.base.Objects;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableMap;
import com.basistech.shaded.dm.com.google.common.collect.ImmutableSet;
import com.basistech.util.ISO15924;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class Transliteration
extends BaseAttribute {
    private Map<ISO15924, String> scriptMap;

    protected Transliteration(Map<ISO15924, String> scriptMap, Map<String, Object> extendedAttributes) {
        super(extendedAttributes);
        this.scriptMap = ImmutableMap.copyOf(scriptMap);
    }

    public String get(ISO15924 script) {
        return this.scriptMap.get(script);
    }

    public static Transliteration of(ISO15924 script, String value) {
        return Builder.of(script, value).build();
    }

    public Set<ISO15924> listScripts() {
        return ImmutableSet.copyOf(this.scriptMap.keySet());
    }

    public Map<ISO15924, String> getAll() {
        return this.scriptMap;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Transliteration that = (Transliteration)o;
        return this.scriptMap != null ? this.scriptMap.equals(that.scriptMap) : that.scriptMap == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.scriptMap != null ? this.scriptMap.hashCode() : 0);
        return result;
    }

    @Override
    public Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper(this).add("scriptMap", this.scriptMap);
    }

    public static final class Builder
    extends BaseAttribute.Builder<Transliteration, Builder> {
        private Map<ISO15924, String> scriptMap;

        public Builder(ISO15924 script, String value) {
            this.scriptMap = new HashMap<ISO15924, String>();
            this.scriptMap.put(script, value);
        }

        public Builder(Transliteration other) {
            this.scriptMap = new HashMap<ISO15924, String>(other.scriptMap);
        }

        public Builder() {
            this.scriptMap = new HashMap<ISO15924, String>();
        }

        public Builder add(ISO15924 script, String value) {
            this.scriptMap.put(script, value);
            return this;
        }

        public Builder add(Transliteration transliteration) {
            this.scriptMap.putAll(transliteration.scriptMap);
            return this;
        }

        public Builder clearTransliterations() {
            this.scriptMap.clear();
            return this;
        }

        public Builder transliterations(Map<ISO15924, String> forLang) {
            this.scriptMap = new HashMap<ISO15924, String>(forLang);
            return this;
        }

        public static Builder of(ISO15924 script, String transliteration) {
            return new Builder(script, transliteration);
        }

        public static Builder of(Transliteration transliteration) {
            return new Builder(transliteration);
        }

        public Transliteration build() {
            return new Transliteration(this.scriptMap, this.buildExtendedProperties());
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

