/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.bbhmp;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.codehaus.plexus.util.SelectorUtils;

class ArtifactId {
    private final String groupId;
    private final String artifactId;
    private final String type;
    private final String classifier;
    private final String version;

    ArtifactId(Dependency dependency) {
        this(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier(), dependency.getVersion());
    }

    ArtifactId(Artifact artifact) {
        this(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersion());
    }

    ArtifactId(String groupId, String artifactId, String type, String classifier, String version) {
        this.groupId = groupId != null ? groupId : "";
        this.artifactId = artifactId != null ? artifactId : "";
        this.type = type != null ? type : "";
        this.classifier = classifier != null ? classifier : "";
        this.version = version != null ? version : "";
    }

    ArtifactId(String id) {
        String[] tokens = new String[]{};
        if (id != null && id.length() > 0) {
            tokens = id.split(":", -1);
        }
        this.groupId = tokens.length > 0 ? tokens[0] : "";
        this.artifactId = tokens.length > 1 ? tokens[1] : "*";
        String string = this.type = tokens.length > 3 ? tokens[2] : "*";
        this.classifier = tokens.length > 3 ? tokens[3] : (tokens.length > 2 ? tokens[2] : "*");
        this.version = tokens.length > 4 ? tokens[4] : "*";
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getType() {
        return this.type;
    }

    String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version;
    }

    boolean matches(ArtifactId pattern) {
        if (pattern == null) {
            return false;
        }
        if (!this.match(this.getGroupId(), pattern.getGroupId())) {
            return false;
        }
        if (!this.match(this.getArtifactId(), pattern.getArtifactId())) {
            return false;
        }
        if (!this.match(this.getType(), pattern.getType())) {
            return false;
        }
        if (!this.match(this.getClassifier(), pattern.getClassifier())) {
            return false;
        }
        return this.match(this.getVersion(), pattern.getVersion());
    }

    private boolean match(String str, String pattern) {
        return SelectorUtils.match((String)pattern, (String)str);
    }
}

