/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.bbhmp;

import org.apache.maven.plugin.MojoFailureException;

class KarafBundleCoordinates {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;

    KarafBundleCoordinates(String uri) throws MojoFailureException {
        if (!uri.startsWith("mvn:")) {
            throw new IllegalArgumentException("Bundle location is not an mvn: URI: " + uri);
        }
        String[] pieces = uri.substring(4).split("/");
        if (pieces.length < 3) {
            throw new MojoFailureException("Invalid bundle location: " + uri);
        }
        this.groupId = pieces[0];
        this.artifactId = pieces[1];
        this.version = pieces[2];
        if (pieces.length >= 5) {
            if (!"jar".equals(pieces[3])) {
                throw new MojoFailureException("Non-jar 'bundle' " + uri);
            }
            this.classifier = pieces[4];
        } else {
            this.classifier = null;
        }
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }
}

