/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.bbhmp;

import com.basistech.bbhmp.BundleInfo;
import com.basistech.bbhmp.IncludeExcludeArtifactFilter;
import com.basistech.bbhmp.KarafBundleCoordinates;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.apache.karaf.features.internal.model.JaxbUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import shaded.org.apache.commons.io.IOUtils;

@Mojo(name="repackage-karaf-features", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class KarafFeatureConverterMojo
extends AbstractMojo {
    @Parameter(required=true)
    List<File> featuresFiles;
    @Parameter(defaultValue="${project.build.directory}/bundles")
    File outputDirectory;
    @Parameter(defaultValue="70")
    int defaultStartLevel;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter
    Set<String> features;
    @Parameter
    Set<String> featureIncludes;
    @Parameter
    Set<String> featureExcludes;
    @Parameter
    Set<String> bundleIncludes;
    @Parameter
    Set<String> bundleExcludes;
    @Parameter
    boolean verboseBundles;
    @Parameter(defaultValue="true")
    boolean verboseFeatures;
    @Component
    ArtifactResolver resolver;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    ArtifactRepository local;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    List<ArtifactRepository> remoteRepos;
    @Component
    ArtifactFactory factory;
    private Map<Integer, List<BundleInfo>> accumulatedBundles;
    private IncludeExcludeArtifactFilter bundleFilter;
    private Set<String> bundlesProcessed;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.accumulatedBundles = new TreeMap<Integer, List<BundleInfo>>();
        this.bundlesProcessed = new HashSet<String>();
        this.bundleFilter = new IncludeExcludeArtifactFilter(this.bundleIncludes, this.bundleExcludes, null);
        for (File featuresFile : this.featuresFiles) {
            this.processOneFeatureFile(featuresFile);
        }
        if (this.features != null && !this.features.isEmpty()) {
            for (String feature : this.features) {
                this.getLog().error((CharSequence)("Feature not found: " + feature));
            }
            throw new MojoExecutionException("Not all features were found.");
        }
        this.writeMetadata();
    }

    private void processOneFeatureFile(File featuresFile) throws MojoExecutionException, MojoFailureException {
        Features featuresFromXml;
        try {
            FileInputStream is = new FileInputStream(featuresFile);
            featuresFromXml = JaxbUtil.unmarshal((String)featuresFile.toURI().toString(), (InputStream)is, (boolean)true);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Failed to read " + featuresFile.toString(), (Exception)ex);
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        for (Feature feature : featuresFromXml.getFeature()) {
            if (this.acceptFeature(feature)) {
                if (this.verboseFeatures) {
                    this.getLog().info((CharSequence)("Including feature " + feature.getName()));
                }
                for (Bundle bundle : feature.getBundle()) {
                    this.processBundle(bundle);
                }
                continue;
            }
            if (!this.verboseFeatures) continue;
            this.getLog().info((CharSequence)("Excluding feature " + feature.getName()));
        }
    }

    private boolean acceptFeature(Feature feature) {
        if (this.features != null) {
            if (this.features.contains(feature.getName())) {
                this.features.remove(feature.getName());
                return true;
            }
            return false;
        }
        if (this.featureIncludes != null && this.featureIncludes.size() > 0 && !this.featureIncludes.contains(feature.getName())) {
            return false;
        }
        if (this.featureExcludes != null && this.featureExcludes.size() > 0) {
            return !this.featureExcludes.contains(feature.getName());
        }
        return true;
    }

    private void writeMetadata() throws MojoExecutionException {
        FileOutputStream os = null;
        File md = new File(this.outputDirectory, "bundles.xml");
        try {
            os = new FileOutputStream(md);
            XMLStreamWriter writer = XMLOutputFactory.newFactory().createXMLStreamWriter(os);
            writer = new IndentingXMLStreamWriter(writer);
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeStartElement("bundles");
            for (Map.Entry<Integer, List<BundleInfo>> me : this.accumulatedBundles.entrySet()) {
                writer.writeStartElement("level");
                writer.writeAttribute("level", Integer.toString(me.getKey()));
                for (BundleInfo bi : me.getValue()) {
                    writer.writeStartElement("bundle");
                    writer.writeAttribute("start", Boolean.toString(bi.start));
                    writer.writeCharacters(bi.location);
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.flush();
        }
        catch (IOException | XMLStreamException e) {
            try {
                throw new MojoExecutionException("Failed to write metadata file " + md.toString(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    private void processBundle(Bundle bundle) throws MojoExecutionException, MojoFailureException {
        List<BundleInfo> infoList;
        String outputFilename;
        Artifact artifact = this.getArtifact(bundle);
        if (!this.bundleFilter.isSelected(artifact)) {
            if (this.verboseBundles) {
                this.getLog().info((CharSequence)String.format("Bundle %s excluded", artifact.getId()));
            }
            return;
        }
        if (this.verboseBundles) {
            this.getLog().info((CharSequence)String.format("Bundle %s included", artifact.getId()));
        }
        if (this.bundlesProcessed.contains(outputFilename = String.format("%s-%s-%s.jar", artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()))) {
            if (this.verboseBundles) {
                this.getLog().info((CharSequence)String.format("Bundle %s duplicated", artifact.getId()));
            }
            return;
        }
        File outputFile = new File(this.outputDirectory, outputFilename);
        this.copyFile(artifact.getFile(), outputFile);
        int startLevel = bundle.getStartLevel();
        if (startLevel == 0) {
            startLevel = this.defaultStartLevel;
        }
        if ((infoList = this.accumulatedBundles.get(startLevel)) == null) {
            infoList = new ArrayList<BundleInfo>();
            this.accumulatedBundles.put(startLevel, infoList);
        }
        infoList.add(new BundleInfo(bundle.isStart(), outputFilename));
    }

    private void copyFile(File artifact, File destFile) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Copying " + artifact.getAbsolutePath() + destFile));
            if (artifact.isDirectory()) {
                throw new MojoExecutionException("Artifact has not been packaged yet.");
            }
            FileUtils.copyFile((File)artifact, (File)destFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, (Exception)e);
        }
    }

    protected Artifact getArtifact(Bundle bundle) throws MojoExecutionException, MojoFailureException {
        VersionRange vr;
        KarafBundleCoordinates coords;
        try {
            coords = new KarafBundleCoordinates(bundle.getLocation());
        }
        catch (IllegalArgumentException e) {
            this.getLog().warn((CharSequence)("Non-mvn: bundle skipped: " + bundle.getLocation()));
            return null;
        }
        try {
            vr = VersionRange.createFromVersionSpec((String)coords.getVersion());
        }
        catch (InvalidVersionSpecificationException e1) {
            throw new MojoExecutionException("Bad version range " + coords.getVersion(), (Exception)((Object)e1));
        }
        Artifact artifact = this.factory.createDependencyArtifact(coords.getGroupId(), coords.getArtifactId(), vr, "jar", coords.getClassifier(), "compile");
        Artifact result = this.getArtifactFomReactor(artifact);
        if (result != null) {
            return result;
        }
        try {
            this.resolver.resolve(artifact, this.remoteRepos, this.local);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact.", (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to find artifact.", (Exception)((Object)e));
        }
        return artifact;
    }

    private Artifact getArtifactFomReactor(Artifact artifact) {
        for (Artifact artifact2 : this.project.getArtifacts()) {
            if (!KarafFeatureConverterMojo.equals(artifact, artifact2) || !KarafFeatureConverterMojo.hasFile(artifact2)) continue;
            return artifact2;
        }
        for (MavenProject mavenProject : this.reactorProjects == null ? Collections.emptyList() : this.reactorProjects) {
            if (KarafFeatureConverterMojo.equals(artifact, mavenProject.getArtifact()) && KarafFeatureConverterMojo.hasFile(mavenProject.getArtifact())) {
                return mavenProject.getArtifact();
            }
            for (Artifact a : mavenProject.getAttachedArtifacts()) {
                if (!KarafFeatureConverterMojo.equals(artifact, a) || !KarafFeatureConverterMojo.hasFile(a)) continue;
                return a;
            }
        }
        return null;
    }

    private static boolean hasFile(Artifact artifact) {
        return artifact != null && artifact.getFile() != null && artifact.getFile().isFile();
    }

    private static boolean equals(Artifact a, Artifact b) {
        return a == b || a != null && b != null && StringUtils.equals((String)a.getGroupId(), (String)b.getGroupId()) && StringUtils.equals((String)a.getArtifactId(), (String)b.getArtifactId()) && StringUtils.equals((String)a.getVersion(), (String)b.getVersion()) && StringUtils.equals((String)a.getType(), (String)b.getType()) && StringUtils.equals((String)a.getClassifier(), (String)b.getClassifier());
    }
}

