/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.bbhmp;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="osgi-version", defaultPhase=LifecyclePhase.PROCESS_SOURCES)
public class OsgiVersionMojo
extends AbstractMojo {
    private static final Pattern PLAIN_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)(-SNAPSHOT)?");
    private static final Pattern CXX_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)\\.c[0-9]+\\.[0-9]+(-SNAPSHOT)?");
    private static final String TIMESTAMP_PATTERN = "'v'yyyyMMddhhmmss";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="false")
    boolean timestampQualifier;
    @Parameter(defaultValue="osgi-version")
    String propertyName;

    public void execute() throws MojoExecutionException {
        String result;
        boolean snapshot = this.project.getVersion().endsWith("-SNAPSHOT");
        Matcher matcher = CXX_PATTERN.matcher(this.project.getVersion());
        if (matcher.matches()) {
            result = String.format("%s.%s.%s", matcher.group(1), matcher.group(2), matcher.group(3));
        } else {
            matcher = PLAIN_PATTERN.matcher(this.project.getVersion());
            if (matcher.matches()) {
                result = String.format("%s.%s.%s", matcher.group(1), matcher.group(2), matcher.group(3));
            } else {
                throw new MojoExecutionException(String.format("Version %s does not match either x.y.z or x.y.z.cXX.Y", this.project.getVersion()));
            }
        }
        if (snapshot || this.timestampQualifier) {
            SimpleDateFormat format = new SimpleDateFormat(TIMESTAMP_PATTERN);
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            format.setTimeZone(timeZone);
            Date now = new Date();
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(now);
            ((Calendar)calendar).setTimeZone(timeZone);
            ((Calendar)calendar).add(13, 0);
            result = result + "." + format.format(calendar.getTime());
        }
        this.defineProperty(this.propertyName, result);
    }

    private void defineProperty(String name, String value) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("define property " + name + " = \"" + value + "\""));
        }
        this.project.getProperties().put(name, value);
    }
}

