/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.examples;

import com.basistech.rosette.api.RosetteAPI;
import com.basistech.rosette.api.RosetteAPIException;
import com.basistech.rosette.apimodel.Name;
import com.basistech.rosette.apimodel.NameSimilarityRequest;
import com.basistech.rosette.apimodel.NameSimilarityResponse;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.examples.ExampleBase;
import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import java.io.IOException;

public final class NameSimilarityExample
extends ExampleBase {
    public static void main(String[] args) {
        try {
            new NameSimilarityExample().run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RosetteAPIException {
        String matchedNameData1 = "Michael Jackson";
        String matchedNameData2 = "\u8fc8\u514b\u5c14\u00b7\u6770\u514b\u900a";
        Name name1 = new Name(matchedNameData1, "PERSON", ISO15924.Zyyy, LanguageCode.ENGLISH);
        Name name2 = new Name(matchedNameData2);
        RosetteAPI rosetteApi = new RosetteAPI(this.getApiKeyFromSystemProperty(), this.getAltUrlFromSystemProperty());
        NameSimilarityResponse response = rosetteApi.getNameSimilarity(new NameSimilarityRequest(name1, name2));
        System.out.println(NameSimilarityExample.responseToJson((Response)response));
    }
}

