/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.examples;

import com.basistech.rosette.api.RosetteAPI;
import com.basistech.rosette.api.RosetteAPIException;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.apimodel.SentimentResponse;
import com.basistech.rosette.examples.ExampleBase;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public final class SentimentExample
extends ExampleBase {
    public static void main(String[] args) {
        try {
            new SentimentExample().run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException, RosetteAPIException {
        String sentimentFileFata = "<html><head><title>New Ghostbusters Film</title></head><body><p>Original Ghostbuster Dan Aykroyd, who also co-wrote the 1984 Ghostbusters film, couldn\u2019t be more pleased with the new all-female Ghostbusters cast, telling The Hollywood Reporter, \u201cThe Aykroyd family is delighted by this inheritance of the Ghostbusters torch by these most magnificent women in comedy.\u201d</p></body></html>";
        File file = SentimentExample.createTempDataFile(sentimentFileFata);
        FileInputStream inputStream = new FileInputStream(file);
        RosetteAPI rosetteApi = new RosetteAPI(this.getApiKeyFromSystemProperty(), this.getAltUrlFromSystemProperty());
        SentimentResponse response = rosetteApi.getSentiment((InputStream)inputStream, "text/html", null, null);
        inputStream.close();
        System.out.println(SentimentExample.responseToJson((Response)response));
    }

    private static File createTempDataFile(String data) throws IOException {
        File file = File.createTempFile("rosette-", "-api");
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        bw.write(data);
        bw.close();
        file.deleteOnExit();
        return file;
    }
}

