/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.examples;

import com.basistech.rosette.api.HttpRosetteAPI;
import com.basistech.rosette.apimodel.AddressSimilarityRequest;
import com.basistech.rosette.apimodel.AddressSimilarityResponse;
import com.basistech.rosette.apimodel.FieldedAddress;
import com.basistech.rosette.apimodel.IAddress;
import com.basistech.rosette.apimodel.Request;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.apimodel.UnfieldedAddress;
import com.basistech.rosette.examples.ExampleBase;
import java.io.IOException;

public final class AddressSimilarityExample
extends ExampleBase {
    public static void main(String[] args) {
        try {
            new AddressSimilarityExample().run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException {
        String addressSimilarityHouseno1 = "1600";
        String addressSimilarityRoad1 = "Pennsylvania Ave NW";
        String addressSimilarityCity1 = "Washington";
        String addressSimilarityState1 = "DC";
        String addressSimilarityPostcode1 = "20500";
        FieldedAddress address1 = FieldedAddress.builder().houseNumber(addressSimilarityHouseno1).road(addressSimilarityRoad1).city(addressSimilarityCity1).state(addressSimilarityState1).postCode(addressSimilarityPostcode1).build();
        String addressSimilarityAddress2 = "160 Pennsilvana Avenue, Washington, D.C., 20500";
        UnfieldedAddress address2 = UnfieldedAddress.builder().address(addressSimilarityAddress2).build();
        HttpRosetteAPI rosetteApi = new HttpRosetteAPI.Builder().key(this.getApiKeyFromSystemProperty()).url(this.getAltUrlFromSystemProperty()).build();
        AddressSimilarityRequest request = AddressSimilarityRequest.builder().address1((IAddress)address1).address2((IAddress)address2).build();
        AddressSimilarityResponse response = (AddressSimilarityResponse)rosetteApi.perform("/address-similarity", (Request)request, AddressSimilarityResponse.class);
        System.out.println(AddressSimilarityExample.responseToJson((Response)response));
    }
}

