/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.examples;

import com.basistech.rosette.api.HttpRosetteAPI;
import com.basistech.rosette.apimodel.Name;
import com.basistech.rosette.apimodel.NameSimilarityRequest;
import com.basistech.rosette.apimodel.NameSimilarityResponse;
import com.basistech.rosette.apimodel.Request;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.examples.ExampleBase;
import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import java.io.IOException;

public final class NameSimilarityExample
extends ExampleBase {
    public static void main(String[] args) {
        try {
            new NameSimilarityExample().run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException {
        String matchedNameData1 = "Michael Jackson";
        String matchedNameData2 = "\u8fc8\u514b\u5c14\u00b7\u6770\u514b\u900a";
        Name name1 = Name.builder().text(matchedNameData1).entityType("PERSON").script(ISO15924.Zyyy).language(LanguageCode.ENGLISH).build();
        Name name2 = Name.builder().text(matchedNameData2).build();
        HttpRosetteAPI rosetteApi = new HttpRosetteAPI.Builder().key(this.getApiKeyFromSystemProperty()).url(this.getAltUrlFromSystemProperty()).build();
        NameSimilarityRequest request = NameSimilarityRequest.builder().name1(name1).name2(name2).build();
        NameSimilarityResponse response = (NameSimilarityResponse)rosetteApi.perform("/name-similarity", (Request)request, NameSimilarityResponse.class);
        System.out.println(NameSimilarityExample.responseToJson((Response)response));
    }
}

