/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util;

import com.basistech.util.InvalidNamedEntityTypeNameException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public final class NEConstants {
    public static final int NE_TYPE_USER_DEFINED_START = 0x10000000;
    public static final int NE_TYPE_NONE = 0;
    public static final int NE_TYPE_PERSON = 65536;
    public static final int NE_TYPE_ORGANIZATION = 131072;
    public static final int NE_TYPE_LOCATION = 196608;
    public static final int NE_TYPE_FACILITY = 262144;
    public static final int NE_TYPE_GPE = 327680;
    public static final int NE_TYPE_VEHICLE = 393216;
    public static final int NE_TYPE_WEAPON = 458752;
    public static final int NE_TYPE_TEMPORAL = 524288;
    public static final int NE_TYPE_IDENTIFIER = 589824;
    public static final int NE_TYPE_RELIGION = 655360;
    public static final int NE_TYPE_NATIONALITY = 720896;
    public static final int NE_TYPE_TITLE = 786432;
    public static final int NE_TYPE_TWITTER_USERNAME = 851968;
    public static final int NE_TYPE_HASHTAG = 917504;
    public static final int NE_TYPE_PRODUCT = 983040;
    public static final int NE_TYPE_TEMPORAL_DATE = 524289;
    public static final int NE_TYPE_TEMPORAL_TIME = 524290;
    public static final int NE_TYPE_TEMPORAL_OTHER = 589823;
    public static final int NE_TYPE_IDENTIFIER_EMAIL = 589825;
    public static final int NE_TYPE_IDENTIFIER_URL = 589826;
    public static final int NE_TYPE_IDENTIFIER_DOMAIN_NAME = 589827;
    public static final int NE_TYPE_IDENTIFIER_IP_ADDRESS = 589828;
    public static final int NE_TYPE_IDENTIFIER_PHONE_NUMBER = 589829;
    public static final int NE_TYPE_IDENTIFIER_FAX_NUMBER = 589830;
    public static final int NE_TYPE_IDENTIFIER_PERSONAL_ID_NUM = 589831;
    public static final int NE_TYPE_IDENTIFIER_LATITUDE_LONGITUDE = 589832;
    public static final int NE_TYPE_IDENTIFIER_CREDIT_CARD_NUM = 589833;
    public static final int NE_TYPE_IDENTIFIER_MONEY = 589834;
    public static final int NE_TYPE_IDENTIFIER_PERCENT = 589835;
    public static final int NE_TYPE_IDENTIFIER_UTM = 589836;
    public static final int NE_TYPE_IDENTIFIER_DISTANCE = 589837;
    public static final int NE_TYPE_IDENTIFIER_NUMBER = 589838;
    public static final int NE_TYPE_IDENTIFIER_OTHER = 655359;
    public static final String NAMED_ENTITY_NONE = "NONE";
    public static final String NAMED_ENTITY_PERSON = "PERSON";
    public static final String NAMED_ENTITY_ORGANIZATION = "ORGANIZATION";
    public static final String NAMED_ENTITY_LOCATION = "LOCATION";
    public static final String NAMED_ENTITY_FACILITY = "FACILITY";
    public static final String NAMED_ENTITY_GPE = "GPE";
    public static final String NAMED_ENTITY_VEHICLE = "VEHICLE";
    public static final String NAMED_ENTITY_WEAPON = "WEAPON";
    public static final String NAMED_ENTITY_TEMPORAL = "TEMPORAL";
    public static final String NAMED_ENTITY_TEMPORAL_DATE = "TEMPORAL:DATE";
    public static final String NAMED_ENTITY_TEMPORAL_TIME = "TEMPORAL:TIME";
    public static final String NAMED_ENTITY_TEMPORAL_OTHER = "TEMPORAL:OTHER";
    public static final String NAMED_ENTITY_IDENTIFIER = "IDENTIFIER";
    public static final String NAMED_ENTITY_IDENTIFIER_EMAIL = "IDENTIFIER:EMAIL";
    public static final String NAMED_ENTITY_IDENTIFIER_URL = "IDENTIFIER:URL";
    public static final String NAMED_ENTITY_IDENTIFIER_DOMAIN_NAME = "IDENTIFIER:DOMAIN_NAME";
    public static final String NAMED_ENTITY_IDENTIFIER_IP_ADDRESS = "IDENTIFIER:IP_ADDRESS";
    public static final String NAMED_ENTITY_IDENTIFIER_PHONE_NUMBER = "IDENTIFIER:PHONE_NUMBER";
    public static final String NAMED_ENTITY_IDENTIFIER_FAX_NUMBER = "IDENTIFIER:FAX_NUMBER";
    public static final String NAMED_ENTITY_IDENTIFIER_PERSONAL_ID_NUM = "IDENTIFIER:PERSONAL_ID_NUM";
    public static final String NAMED_ENTITY_IDENTIFIER_LATITUDE_LONGITUDE = "IDENTIFIER:LATITUDE_LONGITUDE";
    public static final String NAMED_ENTITY_IDENTIFIER_CREDIT_CARD_NUM = "IDENTIFIER:CREDIT_CARD_NUM";
    public static final String NAMED_ENTITY_IDENTIFIER_MONEY = "IDENTIFIER:MONEY";
    public static final String NAMED_ENTITY_IDENTIFIER_PERCENT = "IDENTIFIER:PERCENT";
    public static final String NAMED_ENTITY_IDENTIFIER_UTM = "IDENTIFIER:UTM";
    public static final String NAMED_ENTITY_IDENTIFIER_DISTANCE = "IDENTIFIER:DISTANCE";
    public static final String NAMED_ENTITY_IDENTIFIER_NUMBER = "IDENTIFIER:NUMBER";
    public static final String NAMED_ENTITY_IDENTIFIER_OTHER = "IDENTIFIER:OTHER";
    public static final String NAMED_ENTITY_RELIGION = "RELIGION";
    public static final String NAMED_ENTITY_NATIONALITY = "NATIONALITY";
    public static final String NAMED_ENTITY_TITLE = "TITLE";
    public static final String NAMED_ENTITY_TWITTER_USERNAME = "TWITTER_USERNAME";
    public static final String NAMED_ENTITY_HASHTAG = "HASHTAG";
    public static final String NAMED_ENTITY_PRODUCT = "PRODUCT";
    private static Map<Integer, String> neMap = new TreeMap<Integer, String>();
    private static final Map<String, Integer> neTypeMap;
    public static final int RLP_LP_NONE = 0;
    public static final int RLP_LP_STAT = 0x1000000;
    public static final int RLP_LP_GAZ = 0x2000000;
    public static final int RLP_LP_REGEX = 0x3000000;

    private NEConstants() {
    }

    public static String toString(int v) {
        return neMap.get(new Integer(v));
    }

    public static int parse(String s) throws InvalidNamedEntityTypeNameException {
        String key = s.toUpperCase(Locale.ENGLISH);
        if (neTypeMap.containsKey(key)) {
            return neTypeMap.get(key);
        }
        throw new InvalidNamedEntityTypeNameException("No type. Named entity \"" + key + "\" is not supported.");
    }

    public static String getSourceLPName(int v) {
        switch (v) {
            case 0: {
                return "none";
            }
            case 0x1000000: {
                return "statistical";
            }
            case 0x2000000: {
                return "gazetteer";
            }
            case 0x3000000: {
                return "regex";
            }
        }
        return NAMED_ENTITY_NONE;
    }

    public static int getSourceLPID(String s) {
        if (s.equals("STAT") || s.equals("statistical")) {
            return 0x1000000;
        }
        if (s.equals("GAZE") || s.equals("gazetteer")) {
            return 0x2000000;
        }
        if (s.equals("REGX") || s.equals("regex")) {
            return 0x3000000;
        }
        return 0;
    }

    public static int extractType(int t) {
        return t & 0xFFFF0000;
    }

    public static int extractSubtype(int t) {
        return t & 0xFFFF;
    }

    public static int extractLP(int s) {
        return s & 0xFF000000;
    }

    public static int extractSubsource(int s) {
        return s & 0xFFFFFF;
    }

    public static boolean isNONE(int t) {
        return NEConstants.extractType(t) == 0;
    }

    public static boolean isPERSON(int t) {
        return NEConstants.extractType(t) == 65536;
    }

    public static boolean isORGANIZATION(int t) {
        return NEConstants.extractType(t) == 131072;
    }

    public static boolean isLOCATION(int t) {
        return NEConstants.extractType(t) == 196608;
    }

    public static boolean isFACILITY(int t) {
        return NEConstants.extractType(t) == 262144;
    }

    public static boolean isGPE(int t) {
        return NEConstants.extractType(t) == 327680;
    }

    public static boolean isVEHICLE(int t) {
        return NEConstants.extractType(t) == 393216;
    }

    public static boolean isWEAPON(int t) {
        return NEConstants.extractType(t) == 458752;
    }

    public static boolean isTEMPORAL(int t) {
        return NEConstants.extractType(t) == 524288;
    }

    public static boolean isIDENTIFIER(int t) {
        return NEConstants.extractType(t) == 589824;
    }

    public static boolean isRELIGION(int t) {
        return NEConstants.extractType(t) == 655360;
    }

    public static boolean isNATIONALITY(int t) {
        return NEConstants.extractType(t) == 720896;
    }

    public static boolean isTITLE(int t) {
        return NEConstants.extractType(t) == 786432;
    }

    public static boolean isTWITTER_USERNAME(int t) {
        return NEConstants.extractType(t) == 851968;
    }

    public static boolean isHASHTAG(int t) {
        return NEConstants.extractType(t) == 917504;
    }

    public static boolean isPRODUCT(int t) {
        return NEConstants.extractType(t) == 983040;
    }

    static {
        neMap.put(new Integer(0), NAMED_ENTITY_NONE);
        neMap.put(new Integer(65536), NAMED_ENTITY_PERSON);
        neMap.put(new Integer(131072), NAMED_ENTITY_ORGANIZATION);
        neMap.put(new Integer(196608), NAMED_ENTITY_LOCATION);
        neMap.put(new Integer(262144), NAMED_ENTITY_FACILITY);
        neMap.put(new Integer(327680), NAMED_ENTITY_GPE);
        neMap.put(new Integer(393216), NAMED_ENTITY_VEHICLE);
        neMap.put(new Integer(458752), NAMED_ENTITY_WEAPON);
        neMap.put(new Integer(524288), NAMED_ENTITY_TEMPORAL);
        neMap.put(new Integer(524289), NAMED_ENTITY_TEMPORAL_DATE);
        neMap.put(new Integer(524290), NAMED_ENTITY_TEMPORAL_TIME);
        neMap.put(new Integer(589823), NAMED_ENTITY_TEMPORAL_OTHER);
        neMap.put(new Integer(589824), NAMED_ENTITY_IDENTIFIER);
        neMap.put(new Integer(589825), NAMED_ENTITY_IDENTIFIER_EMAIL);
        neMap.put(new Integer(589826), NAMED_ENTITY_IDENTIFIER_URL);
        neMap.put(new Integer(589827), NAMED_ENTITY_IDENTIFIER_DOMAIN_NAME);
        neMap.put(new Integer(589828), NAMED_ENTITY_IDENTIFIER_IP_ADDRESS);
        neMap.put(new Integer(589829), NAMED_ENTITY_IDENTIFIER_PHONE_NUMBER);
        neMap.put(new Integer(589830), NAMED_ENTITY_IDENTIFIER_FAX_NUMBER);
        neMap.put(new Integer(589831), NAMED_ENTITY_IDENTIFIER_PERSONAL_ID_NUM);
        neMap.put(new Integer(589832), NAMED_ENTITY_IDENTIFIER_LATITUDE_LONGITUDE);
        neMap.put(new Integer(589833), NAMED_ENTITY_IDENTIFIER_CREDIT_CARD_NUM);
        neMap.put(new Integer(589834), NAMED_ENTITY_IDENTIFIER_MONEY);
        neMap.put(new Integer(589835), NAMED_ENTITY_IDENTIFIER_PERCENT);
        neMap.put(new Integer(589836), NAMED_ENTITY_IDENTIFIER_UTM);
        neMap.put(new Integer(589837), NAMED_ENTITY_IDENTIFIER_DISTANCE);
        neMap.put(new Integer(589838), NAMED_ENTITY_IDENTIFIER_NUMBER);
        neMap.put(new Integer(655359), NAMED_ENTITY_IDENTIFIER_OTHER);
        neMap.put(new Integer(655360), NAMED_ENTITY_RELIGION);
        neMap.put(new Integer(720896), NAMED_ENTITY_NATIONALITY);
        neMap.put(new Integer(786432), NAMED_ENTITY_TITLE);
        neMap.put(new Integer(851968), NAMED_ENTITY_TWITTER_USERNAME);
        neMap.put(new Integer(917504), NAMED_ENTITY_HASHTAG);
        neMap.put(new Integer(983040), NAMED_ENTITY_PRODUCT);
        neTypeMap = new HashMap<String, Integer>();
        neTypeMap.put(NAMED_ENTITY_NONE, 0);
        neTypeMap.put(NAMED_ENTITY_PERSON, 65536);
        neTypeMap.put(NAMED_ENTITY_ORGANIZATION, 131072);
        neTypeMap.put(NAMED_ENTITY_LOCATION, 196608);
        neTypeMap.put(NAMED_ENTITY_FACILITY, 262144);
        neTypeMap.put(NAMED_ENTITY_GPE, 327680);
        neTypeMap.put(NAMED_ENTITY_VEHICLE, 393216);
        neTypeMap.put(NAMED_ENTITY_WEAPON, 458752);
        neTypeMap.put(NAMED_ENTITY_TEMPORAL, 524288);
        neTypeMap.put(NAMED_ENTITY_TEMPORAL_DATE, 524289);
        neTypeMap.put(NAMED_ENTITY_TEMPORAL_TIME, 524290);
        neTypeMap.put(NAMED_ENTITY_TEMPORAL_OTHER, 589823);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER, 589824);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_EMAIL, 589825);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_URL, 589826);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_DOMAIN_NAME, 589827);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_IP_ADDRESS, 589828);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_PHONE_NUMBER, 589829);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_FAX_NUMBER, 589830);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_PERSONAL_ID_NUM, 589831);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_LATITUDE_LONGITUDE, 589832);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_CREDIT_CARD_NUM, 589833);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_MONEY, 589834);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_PERCENT, 589835);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_UTM, 589836);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_DISTANCE, 589837);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_NUMBER, 589838);
        neTypeMap.put(NAMED_ENTITY_IDENTIFIER_OTHER, 655359);
        neTypeMap.put(NAMED_ENTITY_RELIGION, 655360);
        neTypeMap.put(NAMED_ENTITY_NATIONALITY, 720896);
        neTypeMap.put(NAMED_ENTITY_TITLE, 786432);
        neTypeMap.put(NAMED_ENTITY_TWITTER_USERNAME, 851968);
        neTypeMap.put(NAMED_ENTITY_HASHTAG, 917504);
        neTypeMap.put(NAMED_ENTITY_PRODUCT, 983040);
    }
}

