/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util;

import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import com.basistech.util.TransliterationScheme;
import java.io.Serializable;

public class TextDomain
implements Serializable,
Comparable<TextDomain> {
    private ISO15924 theScript;
    private LanguageCode theLanguage;
    private TransliterationScheme theScheme;

    public TextDomain(ISO15924 script, LanguageCode language, TransliterationScheme scheme) {
        this.theScript = script;
        this.theLanguage = language;
        this.theScheme = scheme;
    }

    public TextDomain(LanguageCode language) {
        this.theScript = language.getDefaultScript();
        this.theLanguage = language;
        this.theScheme = TransliterationScheme.NATIVE;
    }

    TextDomain() {
        this.theScript = ISO15924.Zyyy;
        this.theLanguage = LanguageCode.UNKNOWN;
        this.theScheme = TransliterationScheme.UNKNOWN;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextDomain)) {
            return false;
        }
        return this.getScript() == ((TextDomain)o).getScript() && this.getLanguage() == ((TextDomain)o).getLanguage() && this.getTransliterationScheme() == ((TextDomain)o).getTransliterationScheme();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getScript().hashCode();
        result = 37 * result + this.getLanguage().hashCode();
        result = 37 * result + this.getTransliterationScheme().hashCode();
        return result;
    }

    public ISO15924 getScript() {
        return this.theScript;
    }

    void setScript(ISO15924 script) {
        this.theScript = script;
    }

    public LanguageCode getLanguage() {
        return this.theLanguage;
    }

    void setLanguage(LanguageCode lang) {
        this.theLanguage = lang;
    }

    public TransliterationScheme getTransliterationScheme() {
        return this.theScheme;
    }

    void setTransliterationScheme(TransliterationScheme scheme) {
        this.theScheme = scheme;
    }

    public String toString() {
        return "[" + this.theScript.code4() + "/" + this.theLanguage.ISO639_3() + "/" + this.theScheme.getName() + "]";
    }

    @Override
    public int compareTo(TextDomain o) {
        if (this.theScript.numeric() > o.getScript().numeric()) {
            return 1;
        }
        if (this.theScript.numeric() < o.getScript().numeric()) {
            return -1;
        }
        if (this.theLanguage.languageID() > o.getLanguage().languageID()) {
            return 1;
        }
        if (this.theLanguage.languageID() < o.getLanguage().languageID()) {
            return -1;
        }
        if (this.theScheme.getNativeCode() > o.getTransliterationScheme().getNativeCode()) {
            return 1;
        }
        if (this.theScheme.getNativeCode() < o.getTransliterationScheme().getNativeCode()) {
            return -1;
        }
        return 0;
    }
}

