/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util.jackson;

import com.basistech.util.LanguageCode;
import com.basistech.util.jackson.DynamicKeySerializer;
import com.basistech.util.jackson.LanguageCodeKeyDeserializer;
import com.basistech.util.jackson.LanguageCodeKeySerializer;
import com.basistech.util.jackson.LanguageCodeMixin;
import com.basistech.util.jackson.ModuleVersion;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.databind.deser.std.MapDeserializer;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleKeyDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.type.MapType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class EnumModule
extends SimpleModule {
    public EnumModule() {
        super(ModuleVersion.VERSION);
    }

    public void setupModule(Module.SetupContext context) {
        context.setMixInAnnotations(LanguageCode.class, LanguageCodeMixin.class);
        SimpleSerializers keySerializers = new SimpleSerializers();
        keySerializers.addSerializer((JsonSerializer)new LanguageCodeKeySerializer());
        keySerializers.addSerializer(Object.class, (JsonSerializer)new DynamicKeySerializer());
        context.addKeySerializers((Serializers)keySerializers);
        SimpleKeyDeserializers keyDeserializers = new SimpleKeyDeserializers();
        keyDeserializers.addDeserializer(LanguageCode.class, (KeyDeserializer)new LanguageCodeKeyDeserializer());
        context.addDeserializers((Deserializers)new CustomDeserializers());
    }

    public static ObjectMapper setupObjectMapper(ObjectMapper mapper) {
        EnumModule module = new EnumModule();
        mapper.registerModule((Module)module);
        return mapper;
    }

    private class CustomDeserializers
    extends SimpleDeserializers {
        private CustomDeserializers() {
        }

        public JsonDeserializer<?> findMapDeserializer(MapType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
            if (type.getKeyType().getRawClass() == LanguageCode.class) {
                JavaType linkedHashMap = config.getTypeFactory().constructSpecializedType((JavaType)type, LinkedHashMap.class);
                beanDesc = config.introspectForCreation(linkedHashMap);
                List ctors = beanDesc.getConstructors();
                CreatorCollector creators = new CreatorCollector(beanDesc, false);
                for (AnnotatedConstructor ctor : ctors) {
                    if (ctor.getParameterCount() != 1 || ctor.getRawParameterType(0) != Integer.TYPE) continue;
                    creators.addIntCreator((AnnotatedWithParams)ctor, false);
                }
                AnnotatedConstructor defaultCtor = beanDesc.findDefaultConstructor();
                creators.setDefaultCreator((AnnotatedWithParams)defaultCtor);
                ValueInstantiator valueInstantiator = creators.constructValueInstantiator(config);
                return new PatchedMapDeserializer(linkedHashMap, valueInstantiator, keyDeserializer, elementDeserializer, elementTypeDeserializer);
            }
            return null;
        }
    }

    private static class PatchedMapDeserializer
    extends MapDeserializer {
        PatchedMapDeserializer(JavaType mapType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
            super(mapType, valueInstantiator, keyDeser, valueDeser, valueTypeDeser);
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            String[] moreToIgnore;
            AnnotatedMember member;
            KeyDeserializer kd = this._keyDeserializer;
            if (kd == null) {
                kd = this._mapType.getKeyType().getRawClass() == LanguageCode.class ? new LanguageCodeKeyDeserializer() : ctxt.findKeyDeserializer(this._mapType.getKeyType(), property);
            } else if (kd instanceof ContextualKeyDeserializer) {
                kd = ((ContextualKeyDeserializer)kd).createContextual(ctxt, property);
            }
            JsonDeserializer vd = this._valueDeserializer;
            if (property != null) {
                vd = this.findConvertingContentDeserializer(ctxt, property, vd);
            }
            JavaType vt = this._mapType.getContentType();
            vd = vd == null ? ctxt.findContextualValueDeserializer(vt, property) : ctxt.handleSecondaryContextualization(vd, property, vt);
            TypeDeserializer vtd = this._valueTypeDeserializer;
            if (vtd != null) {
                vtd = vtd.forProperty(property);
            }
            HashSet<String> ignored = this._ignorableProperties;
            AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
            if (intr != null && property != null && (member = property.getMember()) != null && (moreToIgnore = intr.findPropertiesToIgnore((Annotated)member, false)) != null) {
                ignored = ignored == null ? new HashSet<String>() : new HashSet(ignored);
                for (String str : moreToIgnore) {
                    ignored.add(str);
                }
            }
            return this.withResolved(kd, vtd, vd, ignored);
        }
    }
}

