/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util.jackson;

import com.basistech.util.LanguageCode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.KeyDeserializer;
import java.io.IOException;

public class LanguageCodeKeyDeserializer
extends KeyDeserializer {
    public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
        try {
            return LanguageCode.lookupByISO639(key);
        }
        catch (IllegalArgumentException e) {
            throw ctxt.weirdKeyException(LanguageCode.class, key, "Undefined ISO-639 language code");
        }
    }
}

