/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.rosette.apimodel.LanguageWeight;
import com.basistech.rosette.util.EncodingCode;
import com.basistech.util.LanguageCode;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;

public final class LanguageOptions {
    @Min(value=1L)
    private Integer minValidChars;
    @Min(value=1L)
    private Integer profileDepth;
    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    private Double ambiguityThreshold;
    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    private Double invalidityThreshold;
    private LanguageCode languageHint;
    @DecimalMin(value="1.0")
    @DecimalMax(value="99.0")
    private Double languageHintWeight;
    private EncodingCode encodingHint;
    @DecimalMin(value="1.0")
    @DecimalMax(value="99.0")
    private Double encodingHintWeight;
    private Set<LanguageWeight> languageWeightAdjustments;

    public LanguageOptions() {
    }

    public LanguageOptions(Integer minValidChars, Integer profileDepth, Double ambiguityThreshold, Double invalidityThreshold, LanguageCode languageHint, Double languageHintWeight, EncodingCode encodingHint, Double encodingHintWeight, Set<LanguageWeight> languageWeightAdjustments) {
        this.minValidChars = minValidChars;
        this.profileDepth = profileDepth;
        this.ambiguityThreshold = ambiguityThreshold;
        this.invalidityThreshold = invalidityThreshold;
        this.languageHint = languageHint;
        this.languageHintWeight = languageHintWeight;
        this.encodingHint = encodingHint;
        this.encodingHintWeight = encodingHintWeight;
        this.languageWeightAdjustments = languageWeightAdjustments;
    }

    public Integer getMinValidChars() {
        return this.minValidChars;
    }

    public Integer getProfileDepth() {
        return this.profileDepth;
    }

    public Double getAmbiguityThreshold() {
        return this.ambiguityThreshold;
    }

    public Double getInvalidityThreshold() {
        return this.invalidityThreshold;
    }

    public LanguageCode getLanguageHint() {
        return this.languageHint;
    }

    public Double getLanguageHintWeight() {
        return this.languageHintWeight;
    }

    public EncodingCode getEncodingHint() {
        return this.encodingHint;
    }

    public Double getEncodingHintWeight() {
        return this.encodingHintWeight;
    }

    public Set<LanguageWeight> getLanguageWeightAdjustments() {
        return this.languageWeightAdjustments;
    }

    public void setMinValidChars(Integer minValidChars) {
        this.minValidChars = minValidChars;
    }

    public void setProfileDepth(Integer profileDepth) {
        this.profileDepth = profileDepth;
    }

    public void setAmbiguityThreshold(Double ambiguityThreshold) {
        if (!(ambiguityThreshold >= 0.0) || !(ambiguityThreshold <= 100.0)) {
            throw new IllegalArgumentException("ambiguity threshold value range 0-100");
        }
        this.ambiguityThreshold = ambiguityThreshold;
    }

    public void setInvalidityThreshold(Double invalidityThreshold) {
        if (!(invalidityThreshold >= 0.0) || !(invalidityThreshold <= 100.0)) {
            throw new IllegalArgumentException("invalidity threshold value range 0-100");
        }
        this.invalidityThreshold = invalidityThreshold;
    }

    public void setLanguageHint(LanguageCode languageHint) {
        this.languageHint = languageHint;
    }

    public void setLanguageHintWeight(double languageHintWeight) {
        if (!(languageHintWeight >= 1.0) || !(languageHintWeight <= 99.0)) {
            throw new IllegalArgumentException("language hint weight value range 1-99");
        }
        this.languageHintWeight = languageHintWeight;
    }

    public void setEncodingHint(EncodingCode encodingHint) {
        this.encodingHint = encodingHint;
    }

    public void setEncodingHintWeight(double encodingHintWeight) {
        if (!(encodingHintWeight >= 1.0) || !(encodingHintWeight <= 100.0)) {
            throw new IllegalArgumentException("encoding hint weight range 1-100");
        }
        this.encodingHintWeight = encodingHintWeight;
    }

    public void setLanguageWeightAdjustments(Set<LanguageWeight> languageWeightAdjustments) {
        this.languageWeightAdjustments = languageWeightAdjustments;
    }

    public int hashCode() {
        int result = this.minValidChars != null ? this.minValidChars.hashCode() : 0;
        result = 31 * result + (this.profileDepth != null ? this.profileDepth.hashCode() : 0);
        result = 31 * result + (this.ambiguityThreshold != null ? this.ambiguityThreshold.hashCode() : 0);
        result = 31 * result + (this.invalidityThreshold != null ? this.invalidityThreshold.hashCode() : 0);
        result = 31 * result + (this.languageHint != null ? this.languageHint.hashCode() : 0);
        result = 31 * result + (this.languageHintWeight != null ? this.languageHintWeight.hashCode() : 0);
        result = 31 * result + (this.encodingHint != null ? this.encodingHint.hashCode() : 0);
        result = 31 * result + (this.encodingHintWeight != null ? this.encodingHintWeight.hashCode() : 0);
        result = 31 * result + (this.languageWeightAdjustments != null ? this.languageWeightAdjustments.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LanguageOptions)) {
            return false;
        }
        LanguageOptions that = (LanguageOptions)o;
        return this.minValidChars != null ? this.minValidChars.equals(that.getMinValidChars()) : (that.minValidChars == null && this.profileDepth != null ? this.profileDepth.equals(that.getProfileDepth()) : (that.profileDepth == null && this.ambiguityThreshold != null ? this.ambiguityThreshold.equals(that.getAmbiguityThreshold()) : (that.ambiguityThreshold == null && this.invalidityThreshold != null ? this.invalidityThreshold.equals(that.getInvalidityThreshold()) : (that.invalidityThreshold == null && this.languageHint != null ? this.languageHint.equals((Object)that.getLanguageHint()) : (that.languageHint == null && this.languageHintWeight != null ? this.languageHintWeight.equals(that.getLanguageHintWeight()) : (that.languageHintWeight == null && this.encodingHint != null ? this.encodingHint.equals((Object)that.getEncodingHint()) : (that.encodingHint == null && this.encodingHintWeight != null ? this.encodingHintWeight.equals(that.getEncodingHintWeight()) : (that.encodingHintWeight == null && this.languageWeightAdjustments != null ? this.languageWeightAdjustments.equals(that.getLanguageWeightAdjustments()) : that.languageWeightAdjustments == null))))))));
    }
}

