/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public final class LanguageWeight {
    private final LanguageCode language;
    private final ISO15924 script;
    @Min(value=0L)
    @Max(value=100L)
    private final Integer weight;

    public LanguageWeight(LanguageCode language, ISO15924 script, Integer weight) {
        this.language = language;
        this.script = script;
        this.weight = weight;
    }

    public LanguageWeight(LanguageCode language, Integer weight) {
        this.language = language;
        this.script = null;
        this.weight = weight;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public ISO15924 getScript() {
        return this.script;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public int hashCode() {
        int result = this.language != null ? this.language.hashCode() : 0;
        result = 31 * result + (this.script != null ? this.script.hashCode() : 0);
        result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LanguageWeight)) {
            return false;
        }
        LanguageWeight that = (LanguageWeight)o;
        return this.language != null ? this.language.equals((Object)that.getLanguage()) : (that.language == null && this.weight != null ? this.weight.equals(that.getWeight()) : (that.weight == null && this.script != null ? this.script.equals((Object)that.getScript()) : that.script == null));
    }
}

