/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import com.basistech.util.TransliterationScheme;
import javax.validation.constraints.NotNull;

public final class NameTranslationRequest {
    @NotNull
    private String name;
    private String entityType;
    private ISO15924 sourceScript;
    private LanguageCode sourceLanguageOfOrigin;
    private LanguageCode sourceLanguageOfUse;
    @NotNull
    private LanguageCode targetLanguage;
    private ISO15924 targetScript;
    private TransliterationScheme targetScheme;

    protected NameTranslationRequest(String name, String entityType, ISO15924 sourceScript, LanguageCode sourceLanguageOfOrigin, LanguageCode sourceLanguageOfUse, LanguageCode targetLanguage, ISO15924 targetScript, TransliterationScheme targetScheme) {
        this.name = name;
        this.entityType = entityType;
        this.sourceScript = sourceScript;
        this.sourceLanguageOfOrigin = sourceLanguageOfOrigin;
        this.sourceLanguageOfUse = sourceLanguageOfUse;
        this.targetLanguage = targetLanguage;
        this.targetScript = targetScript;
        this.targetScheme = targetScheme;
    }

    public String getName() {
        return this.name;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public ISO15924 getSourceScript() {
        return this.sourceScript;
    }

    public LanguageCode getSourceLanguageOfOrigin() {
        return this.sourceLanguageOfOrigin;
    }

    public LanguageCode getSourceLanguageOfUse() {
        return this.sourceLanguageOfUse;
    }

    public LanguageCode getTargetLanguage() {
        return this.targetLanguage;
    }

    public ISO15924 getTargetScript() {
        return this.targetScript;
    }

    public TransliterationScheme getTargetScheme() {
        return this.targetScheme;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.entityType != null ? this.entityType.hashCode() : 0);
        result = 31 * result + (this.sourceScript != null ? this.sourceScript.hashCode() : 0);
        result = 31 * result + (this.sourceLanguageOfOrigin != null ? this.sourceLanguageOfOrigin.hashCode() : 0);
        result = 31 * result + (this.sourceLanguageOfUse != null ? this.sourceLanguageOfUse.hashCode() : 0);
        result = 31 * result + (this.targetLanguage != null ? this.targetLanguage.hashCode() : 0);
        result = 31 * result + (this.targetScript != null ? this.targetScript.hashCode() : 0);
        result = 31 * result + (this.targetScheme != null ? this.targetScheme.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof NameTranslationRequest)) {
            return false;
        }
        NameTranslationRequest that = (NameTranslationRequest)o;
        return this.name != null ? this.name.equals(that.getName()) : (that.name == null && this.entityType != null ? this.entityType.equals(that.getEntityType()) : (that.entityType == null && this.sourceScript != null ? this.sourceScript.equals((Object)that.getSourceScript()) : (that.sourceScript == null && this.sourceLanguageOfOrigin != null ? this.sourceLanguageOfOrigin.equals((Object)that.getSourceLanguageOfOrigin()) : (that.sourceLanguageOfOrigin == null && this.sourceLanguageOfUse != null ? this.sourceLanguageOfUse.equals((Object)that.getSourceLanguageOfUse()) : (that.sourceLanguageOfUse == null && this.targetLanguage != null ? this.targetLanguage.equals((Object)that.getTargetLanguage()) : (that.targetLanguage == null && this.targetScript != null ? this.targetScript.equals((Object)that.getTargetScript()) : (that.targetScript == null && this.targetScheme != null ? this.targetScheme.equals((Object)that.getTargetScheme()) : that.targetScheme == null)))))));
    }

    public static class Builder {
        private String name;
        private String entityType;
        private ISO15924 sourceScript;
        private LanguageCode sourceLanguageOfOrigin;
        private LanguageCode sourceLanguageOfUse;
        private LanguageCode targetLanguage;
        private ISO15924 targetScript;
        private TransliterationScheme targetScheme;

        public Builder(String name, LanguageCode targetLanguage) {
            this.name = name;
            this.targetLanguage = targetLanguage;
        }

        public Builder targetScript(ISO15924 targetScript) {
            this.targetScript = targetScript;
            return this;
        }

        public Builder targetScheme(TransliterationScheme targetScheme) {
            this.targetScheme = targetScheme;
            return this;
        }

        public Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public String entityType() {
            return this.entityType;
        }

        public Builder sourceScript(ISO15924 sourceScript) {
            this.sourceScript = sourceScript;
            return this;
        }

        public ISO15924 sourceScript() {
            return this.sourceScript;
        }

        public Builder sourceLanguageOfUse(LanguageCode sourceLanguageOfUse) {
            this.sourceLanguageOfUse = sourceLanguageOfUse;
            return this;
        }

        public LanguageCode sourceLanguageOfUse() {
            return this.sourceLanguageOfUse;
        }

        public Builder sourceLanguageOfOrigin(LanguageCode sourceLanguageOfOrigin) {
            this.sourceLanguageOfOrigin = sourceLanguageOfOrigin;
            return this;
        }

        public LanguageCode sourceLanguageOfOrigin() {
            return this.sourceLanguageOfOrigin;
        }

        public NameTranslationRequest build() {
            return new NameTranslationRequest(this.name, this.entityType, this.sourceScript, this.sourceLanguageOfOrigin, this.sourceLanguageOfUse, this.targetLanguage, this.targetScript, this.targetScheme);
        }
    }
}

