/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.util.LanguageCode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public abstract class Request {
    private LanguageCode language;
    private Object content;
    private String contentUri;
    private String contentType;

    protected Request(LanguageCode language, Object content, String contentUri, String contentType) {
        this.language = language;
        this.content = content;
        this.contentUri = contentUri;
        this.contentType = contentType;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public String getContent() {
        if (this.content instanceof String) {
            return (String)this.content;
        }
        return null;
    }

    public InputStream getContentBytes() {
        if (this.content instanceof InputStream) {
            return (InputStream)this.content;
        }
        return null;
    }

    public Object getRawContent() {
        return this.content;
    }

    public String getContentUri() {
        return this.contentUri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int hashCode() {
        int result = this.language != null ? this.language.hashCode() : 0;
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.contentUri != null ? this.contentUri.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Request)) {
            return false;
        }
        Request that = (Request)o;
        return this.language != null ? this.language.equals((Object)that.getLanguage()) : (that.language == null && this.content != null ? this.content.equals(that.content) : (that.content == null && this.contentUri != null ? this.contentUri.equals(that.getContentUri()) : (that.contentUri == null && this.contentType != null ? this.contentType.equals(that.getContentType()) : that.contentType == null)));
    }

    public static abstract class Builder<T extends Request, O, B extends Builder<T, O, B>> {
        protected LanguageCode language;
        protected Object content;
        protected String contentUri;
        protected String contentType;
        protected O options;

        protected abstract B getThis();

        public B language(LanguageCode language) {
            this.language = language;
            return this.getThis();
        }

        LanguageCode language() {
            return this.language;
        }

        public B content(String content) {
            this.content = content;
            return this.getThis();
        }

        public String contentString() {
            return (String)this.content;
        }

        public B contentUri(String uri) {
            this.contentUri = uri;
            return this.getThis();
        }

        public String contentUri() {
            return this.contentUri;
        }

        public B contentBytes(byte[] bytes, String contentType) {
            this.content = new ByteArrayInputStream(bytes);
            this.contentType = contentType;
            return this.getThis();
        }

        public B contentBytes(InputStream bytes, String contentType) {
            this.content = bytes;
            this.contentType = contentType;
            return this.getThis();
        }

        public InputStream contentBytes() {
            return (InputStream)this.content;
        }

        public String contentType() {
            return this.contentType;
        }

        public B options(O options) {
            this.options = options;
            return this.getThis();
        }

        public O options() {
            return this.options;
        }

        public abstract T build();
    }
}

