/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.api;

import com.basistech.rosette.api.MorphologicalFeature;
import com.basistech.rosette.api.RosetteAPIException;
import com.basistech.rosette.apimodel.CategoriesOptions;
import com.basistech.rosette.apimodel.CategoriesRequest;
import com.basistech.rosette.apimodel.CategoriesResponse;
import com.basistech.rosette.apimodel.EntitiesOptions;
import com.basistech.rosette.apimodel.EntitiesRequest;
import com.basistech.rosette.apimodel.EntitiesResponse;
import com.basistech.rosette.apimodel.ErrorResponse;
import com.basistech.rosette.apimodel.InfoResponse;
import com.basistech.rosette.apimodel.LanguageOptions;
import com.basistech.rosette.apimodel.LanguageRequest;
import com.basistech.rosette.apimodel.LanguageResponse;
import com.basistech.rosette.apimodel.LinkedEntitiesRequest;
import com.basistech.rosette.apimodel.LinkedEntitiesResponse;
import com.basistech.rosette.apimodel.MorphologyOptions;
import com.basistech.rosette.apimodel.MorphologyRequest;
import com.basistech.rosette.apimodel.MorphologyResponse;
import com.basistech.rosette.apimodel.NameSimilarityRequest;
import com.basistech.rosette.apimodel.NameSimilarityResponse;
import com.basistech.rosette.apimodel.NameTranslationRequest;
import com.basistech.rosette.apimodel.NameTranslationResponse;
import com.basistech.rosette.apimodel.PingResponse;
import com.basistech.rosette.apimodel.RelationshipsOptions;
import com.basistech.rosette.apimodel.RelationshipsRequest;
import com.basistech.rosette.apimodel.RelationshipsResponse;
import com.basistech.rosette.apimodel.Request;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.apimodel.SentencesRequest;
import com.basistech.rosette.apimodel.SentencesResponse;
import com.basistech.rosette.apimodel.SentimentOptions;
import com.basistech.rosette.apimodel.SentimentRequest;
import com.basistech.rosette.apimodel.SentimentResponse;
import com.basistech.rosette.apimodel.TokensResponse;
import com.basistech.rosette.apimodel.jackson.ApiModelMixinModule;
import com.basistech.rosette.apimodel.jackson.RequestMixin;
import com.basistech.util.LanguageCode;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RosetteAPI
implements Closeable {
    public static final String DEFAULT_URL_BASE = "https://api.rosette.com/rest/v1";
    public static final String BINDING_VERSION = "0.10";
    public static final String LANGUAGE_SERVICE_PATH = "/language";
    public static final String MORPHOLOGY_SERVICE_PATH = "/morphology";
    public static final String ENTITIES_SERVICE_PATH = "/entities";
    public static final String ENTITIES_LINKED_SERVICE_PATH = "/entities/linked";
    public static final String CATEGORIES_SERVICE_PATH = "/categories";
    public static final String RELATIONSHIPS_SERVICE_PATH = "/relationships";
    public static final String SENTIMENT_SERVICE_PATH = "/sentiment";
    public static final String NAME_TRANSLATION_SERVICE_PATH = "/name-translation";
    public static final String NAME_SIMILARITY_SERVICE_PATH = "/name-similarity";
    public static final String TOKENS_SERVICE_PATH = "/tokens";
    public static final String SENTENCES_SERVICE_PATH = "/sentences";
    public static final String INFO_SERVICE_PATH = "/info";
    public static final String VERSION_CHECK_PATH = "/info?clientVersion=0.10";
    public static final String PING_SERVICE_PATH = "/ping";
    private static final Logger LOG = LoggerFactory.getLogger(RosetteAPI.class);
    private String key;
    private String urlBase = "https://api.rosette.com/rest/v1";
    private int failureRetries;
    private ObjectMapper mapper;
    private CloseableHttpClient httpClient;

    public RosetteAPI(String key) throws IOException, RosetteAPIException {
        this(key, DEFAULT_URL_BASE);
    }

    public RosetteAPI(String key, String alternateUrl) throws IOException, RosetteAPIException {
        Objects.requireNonNull(alternateUrl, "alternateUrl cannot be null");
        this.urlBase = alternateUrl;
        if (this.urlBase.endsWith("/")) {
            this.urlBase = this.urlBase.substring(0, this.urlBase.length() - 1);
        }
        this.key = key;
        this.failureRetries = 1;
        this.mapper = ApiModelMixinModule.setupObjectMapper((ObjectMapper)new ObjectMapper());
        this.httpClient = HttpClients.createDefault();
        this.checkVersionCompatibility();
    }

    public void setFailureRetries(int failureRetries) {
        this.failureRetries = failureRetries >= 0 ? failureRetries : 1;
    }

    public void setAPIKey(String key) {
        this.key = key;
    }

    public InfoResponse info() throws IOException, RosetteAPIException {
        return this.sendGetRequest(this.urlBase + INFO_SERVICE_PATH, InfoResponse.class);
    }

    private boolean checkVersionCompatibility() throws IOException, RosetteAPIException {
        InfoResponse response = this.sendPostRequest("{ body: 'version check' }", this.urlBase + VERSION_CHECK_PATH, InfoResponse.class);
        if (!response.isVersionChecked().booleanValue()) {
            ErrorResponse errResponse = new ErrorResponse("incompatibleVersion", "The server version is not compatible with binding version 0.10");
            throw new RosetteAPIException(200, errResponse);
        }
        return true;
    }

    public PingResponse ping() throws IOException, RosetteAPIException {
        return this.sendGetRequest(this.urlBase + PING_SERVICE_PATH, PingResponse.class);
    }

    public NameSimilarityResponse getNameSimilarity(NameSimilarityRequest request) throws RosetteAPIException, IOException {
        return this.sendPostRequest(request, this.urlBase + NAME_SIMILARITY_SERVICE_PATH, NameSimilarityResponse.class);
    }

    public NameTranslationResponse getNameTranslation(NameTranslationRequest request) throws RosetteAPIException, IOException {
        return this.sendPostRequest(request, this.urlBase + NAME_TRANSLATION_SERVICE_PATH, NameTranslationResponse.class);
    }

    public LanguageResponse getLanguage(InputStream inputStream, String contentType, LanguageOptions options) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        LanguageRequest request = ((LanguageRequest.Builder)((LanguageRequest.Builder)new LanguageRequest.Builder().contentBytes(bytes, contentType)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + LANGUAGE_SERVICE_PATH, LanguageResponse.class);
    }

    public LanguageResponse getLanguage(URL url, LanguageOptions options) throws RosetteAPIException, IOException {
        LanguageRequest request = ((LanguageRequest.Builder)((LanguageRequest.Builder)new LanguageRequest.Builder().contentUri(url.toString())).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + LANGUAGE_SERVICE_PATH, LanguageResponse.class);
    }

    public LanguageResponse getLanguage(String content, LanguageOptions options) throws RosetteAPIException, IOException {
        LanguageRequest request = ((LanguageRequest.Builder)((LanguageRequest.Builder)new LanguageRequest.Builder().content(content)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + LANGUAGE_SERVICE_PATH, LanguageResponse.class);
    }

    public MorphologyResponse getMorphology(MorphologicalFeature morphologicalFeature, InputStream inputStream, String contentType, LanguageCode language, MorphologyOptions options) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        MorphologyRequest request = ((MorphologyRequest.Builder)((MorphologyRequest.Builder)((MorphologyRequest.Builder)new MorphologyRequest.Builder().language(language)).contentBytes(bytes, contentType)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + MORPHOLOGY_SERVICE_PATH + "/" + morphologicalFeature.toString(), MorphologyResponse.class);
    }

    public MorphologyResponse getMorphology(MorphologicalFeature morphologicalFeature, URL url, LanguageCode language, MorphologyOptions options) throws RosetteAPIException, IOException {
        MorphologyRequest request = ((MorphologyRequest.Builder)((MorphologyRequest.Builder)((MorphologyRequest.Builder)new MorphologyRequest.Builder().language(language)).contentUri(url.toString())).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + MORPHOLOGY_SERVICE_PATH + "/" + morphologicalFeature.toString(), MorphologyResponse.class);
    }

    public MorphologyResponse getMorphology(MorphologicalFeature morphologicalFeature, String content, LanguageCode language, MorphologyOptions options) throws RosetteAPIException, IOException {
        MorphologyRequest request = ((MorphologyRequest.Builder)((MorphologyRequest.Builder)((MorphologyRequest.Builder)new MorphologyRequest.Builder().language(language)).content(content)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + MORPHOLOGY_SERVICE_PATH + "/" + morphologicalFeature.toString(), MorphologyResponse.class);
    }

    public EntitiesResponse getEntities(InputStream inputStream, String contentType, LanguageCode language, EntitiesOptions options) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        EntitiesRequest request = ((EntitiesRequest.Builder)((EntitiesRequest.Builder)((EntitiesRequest.Builder)new EntitiesRequest.Builder().language(language)).contentBytes(bytes, contentType)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + ENTITIES_SERVICE_PATH, EntitiesResponse.class);
    }

    public EntitiesResponse getEntities(URL url, LanguageCode language, EntitiesOptions options) throws RosetteAPIException, IOException {
        EntitiesRequest request = ((EntitiesRequest.Builder)((EntitiesRequest.Builder)((EntitiesRequest.Builder)new EntitiesRequest.Builder().language(language)).contentUri(url.toString())).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + ENTITIES_SERVICE_PATH, EntitiesResponse.class);
    }

    public EntitiesResponse getEntities(String content, LanguageCode language, EntitiesOptions options) throws RosetteAPIException, IOException {
        EntitiesRequest request = ((EntitiesRequest.Builder)((EntitiesRequest.Builder)((EntitiesRequest.Builder)new EntitiesRequest.Builder().language(language)).content(content)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + ENTITIES_SERVICE_PATH, EntitiesResponse.class);
    }

    public LinkedEntitiesResponse getLinkedEntities(InputStream inputStream, String contentType, LanguageCode language) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        LinkedEntitiesRequest request = ((LinkedEntitiesRequest.Builder)((LinkedEntitiesRequest.Builder)new LinkedEntitiesRequest.Builder().language(language)).contentBytes(bytes, contentType)).build();
        return this.sendPostRequest(request, this.urlBase + ENTITIES_LINKED_SERVICE_PATH, LinkedEntitiesResponse.class);
    }

    public LinkedEntitiesResponse getLinkedEntities(URL url, LanguageCode language) throws RosetteAPIException, IOException {
        LinkedEntitiesRequest request = ((LinkedEntitiesRequest.Builder)((LinkedEntitiesRequest.Builder)new LinkedEntitiesRequest.Builder().language(language)).contentUri(url.toString())).build();
        return this.sendPostRequest(request, this.urlBase + ENTITIES_LINKED_SERVICE_PATH, LinkedEntitiesResponse.class);
    }

    public LinkedEntitiesResponse getLinkedEntities(String content, LanguageCode language) throws RosetteAPIException, IOException {
        LinkedEntitiesRequest request = ((LinkedEntitiesRequest.Builder)((LinkedEntitiesRequest.Builder)new LinkedEntitiesRequest.Builder().language(language)).content(content)).build();
        return this.sendPostRequest(request, this.urlBase + ENTITIES_LINKED_SERVICE_PATH, LinkedEntitiesResponse.class);
    }

    public CategoriesResponse getCategories(InputStream inputStream, String contentType, LanguageCode language, CategoriesOptions options) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        CategoriesRequest request = ((CategoriesRequest.Builder)((CategoriesRequest.Builder)((CategoriesRequest.Builder)new CategoriesRequest.Builder().language(language)).contentBytes(bytes, contentType)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + CATEGORIES_SERVICE_PATH, CategoriesResponse.class);
    }

    public CategoriesResponse getCategories(URL url, LanguageCode language, CategoriesOptions options) throws RosetteAPIException, IOException {
        CategoriesRequest request = ((CategoriesRequest.Builder)((CategoriesRequest.Builder)((CategoriesRequest.Builder)new CategoriesRequest.Builder().language(language)).contentUri(url.toString())).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + CATEGORIES_SERVICE_PATH, CategoriesResponse.class);
    }

    public CategoriesResponse getCategories(String content, LanguageCode language, CategoriesOptions options) throws RosetteAPIException, IOException {
        CategoriesRequest request = ((CategoriesRequest.Builder)((CategoriesRequest.Builder)((CategoriesRequest.Builder)new CategoriesRequest.Builder().language(language)).content(content)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + CATEGORIES_SERVICE_PATH, CategoriesResponse.class);
    }

    public RelationshipsResponse getRelationships(String content, LanguageCode language, RelationshipsOptions options) throws RosetteAPIException, IOException {
        RelationshipsRequest request = ((RelationshipsRequest.Builder)((RelationshipsRequest.Builder)((RelationshipsRequest.Builder)new RelationshipsRequest.Builder().language(language)).content(content)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + RELATIONSHIPS_SERVICE_PATH, RelationshipsResponse.class);
    }

    public RelationshipsResponse getRelationships(InputStream inputStream, String contentType, LanguageCode language, RelationshipsOptions options) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        RelationshipsRequest request = ((RelationshipsRequest.Builder)((RelationshipsRequest.Builder)((RelationshipsRequest.Builder)new RelationshipsRequest.Builder().language(language)).contentBytes(bytes, contentType)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + RELATIONSHIPS_SERVICE_PATH, RelationshipsResponse.class);
    }

    public RelationshipsResponse getRelationships(URL url, LanguageCode language, RelationshipsOptions options) throws RosetteAPIException, IOException {
        RelationshipsRequest request = ((RelationshipsRequest.Builder)((RelationshipsRequest.Builder)((RelationshipsRequest.Builder)new RelationshipsRequest.Builder().language(language)).contentUri(url.toString())).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + RELATIONSHIPS_SERVICE_PATH, RelationshipsResponse.class);
    }

    public SentimentResponse getSentiment(InputStream inputStream, String contentType, LanguageCode language, SentimentOptions options) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        SentimentRequest request = ((SentimentRequest.Builder)((SentimentRequest.Builder)((SentimentRequest.Builder)new SentimentRequest.Builder().language(language)).contentBytes(bytes, contentType)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + SENTIMENT_SERVICE_PATH, SentimentResponse.class);
    }

    public SentimentResponse getSentiment(URL url, LanguageCode language, SentimentOptions options) throws RosetteAPIException, IOException {
        SentimentRequest request = ((SentimentRequest.Builder)((SentimentRequest.Builder)((SentimentRequest.Builder)new SentimentRequest.Builder().language(language)).contentUri(url.toString())).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + SENTIMENT_SERVICE_PATH, SentimentResponse.class);
    }

    public SentimentResponse getSentiment(String content, LanguageCode language, SentimentOptions options) throws RosetteAPIException, IOException {
        SentimentRequest request = ((SentimentRequest.Builder)((SentimentRequest.Builder)((SentimentRequest.Builder)new SentimentRequest.Builder().language(language)).content(content)).options((Object)options)).build();
        return this.sendPostRequest(request, this.urlBase + SENTIMENT_SERVICE_PATH, SentimentResponse.class);
    }

    public TokensResponse getTokens(InputStream inputStream, String contentType, LanguageCode language) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        MorphologyRequest request = ((MorphologyRequest.Builder)((MorphologyRequest.Builder)new MorphologyRequest.Builder().language(language)).contentBytes(bytes, contentType)).build();
        return this.sendPostRequest(request, this.urlBase + TOKENS_SERVICE_PATH, TokensResponse.class);
    }

    public TokensResponse getTokens(URL url, LanguageCode language) throws RosetteAPIException, IOException {
        MorphologyRequest request = ((MorphologyRequest.Builder)((MorphologyRequest.Builder)new MorphologyRequest.Builder().language(language)).contentUri(url.toString())).build();
        return this.sendPostRequest(request, this.urlBase + TOKENS_SERVICE_PATH, TokensResponse.class);
    }

    public TokensResponse getTokens(String content, LanguageCode language) throws RosetteAPIException, IOException {
        MorphologyRequest request = ((MorphologyRequest.Builder)((MorphologyRequest.Builder)new MorphologyRequest.Builder().language(language)).content(content)).build();
        return this.sendPostRequest(request, this.urlBase + TOKENS_SERVICE_PATH, TokensResponse.class);
    }

    public SentencesResponse getSentences(InputStream inputStream, String contentType, LanguageCode language) throws RosetteAPIException, IOException {
        byte[] bytes = RosetteAPI.getBytes(inputStream);
        SentencesRequest request = ((SentencesRequest.Builder)((SentencesRequest.Builder)new SentencesRequest.Builder().language(language)).contentBytes(bytes, contentType)).build();
        return this.sendPostRequest(request, this.urlBase + SENTENCES_SERVICE_PATH, SentencesResponse.class);
    }

    public SentencesResponse getSentences(URL url, LanguageCode language) throws RosetteAPIException, IOException {
        SentencesRequest request = ((SentencesRequest.Builder)((SentencesRequest.Builder)new SentencesRequest.Builder().language(language)).contentUri(url.toString())).build();
        return this.sendPostRequest(request, this.urlBase + SENTENCES_SERVICE_PATH, SentencesResponse.class);
    }

    public SentencesResponse getSentences(String content, LanguageCode language) throws RosetteAPIException, IOException {
        SentencesRequest request = ((SentencesRequest.Builder)((SentencesRequest.Builder)new SentencesRequest.Builder().language(language)).content(content)).build();
        return this.sendPostRequest(request, this.urlBase + SENTENCES_SERVICE_PATH, SentencesResponse.class);
    }

    public InfoResponse getInfo() throws RosetteAPIException, IOException {
        return this.sendGetRequest(this.urlBase + INFO_SERVICE_PATH, InfoResponse.class);
    }

    public <Req extends Request, Res extends Response> Res doRequest(String endpoint, Req request, Class<Res> responseClass) throws IOException, RosetteAPIException {
        return this.sendPostRequest(request, this.urlBase + endpoint, responseClass);
    }

    private <T extends Response> T sendGetRequest(String urlStr, Class<T> clazz) throws IOException, RosetteAPIException {
        HttpGet get = new HttpGet(urlStr);
        if (this.key != null) {
            get.setHeader("X-RosetteAPI-Key", this.key);
        }
        CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)get);
        return this.getResponse((HttpResponse)httpResponse, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Response> T sendPostRequest(Object request, String urlStr, Class<T> clazz) throws RosetteAPIException, IOException {
        ObjectWriter writer = this.mapper.writer().without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        boolean notPlainText = false;
        if (request instanceof Request) {
            Object rawContent = ((Request)request).getRawContent();
            if (rawContent instanceof String) {
                writer = writer.withView(RequestMixin.Views.Content.class);
            } else if (rawContent != null) {
                notPlainText = true;
            }
        }
        ObjectWriter finalWriter = writer;
        HttpPost post = new HttpPost(urlStr);
        if (notPlainText) {
            this.setupMultipartRequest((Request)request, finalWriter, post);
        } else {
            this.setupPlainRequest(request, finalWriter, post);
        }
        if (this.key != null) {
            post.setHeader("X-RosetteAPI-Key", this.key);
        }
        post.setHeader("Accept-Encoding", "gzip");
        RosetteAPIException lastException = null;
        int numRetries = this.failureRetries;
        while (numRetries-- > 0) {
            CloseableHttpResponse response = null;
            try {
                response = this.httpClient.execute((HttpUriRequest)post);
                T resp = this.getResponse((HttpResponse)response, clazz);
                Header ridHeader = response.getFirstHeader("X-RosetteAPI-Request-Id");
                if (ridHeader != null && ridHeader.getValue() != null) {
                    LOG.debug("Request ID " + ridHeader.getValue());
                }
                T t = resp;
                return t;
            }
            catch (RosetteAPIException e) {
                if (e.getHttpStatusCode() < 500) {
                    throw e;
                }
                lastException = e;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        throw lastException;
    }

    private void setupPlainRequest(final Object request, final ObjectWriter finalWriter, HttpPost post) {
        post.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        post.setEntity((HttpEntity)new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return false;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IOException, UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public void writeTo(OutputStream outstream) throws IOException {
                finalWriter.writeValue(outstream, request);
            }

            public boolean isStreaming() {
                return false;
            }
        });
    }

    private void setupMultipartRequest(final Request request, final ObjectWriter finalWriter, HttpPost post) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMimeSubtype("mixed");
        builder.setMode(HttpMultipartMode.STRICT);
        FormBodyPartBuilder partBuilder = FormBodyPartBuilder.create((String)"request", (ContentBody)new AbstractContentBody(ContentType.parse((String)ContentType.APPLICATION_JSON.getMimeType())){

            public String getFilename() {
                return null;
            }

            public void writeTo(OutputStream out) throws IOException {
                finalWriter.writeValue(out, (Object)request);
            }

            public String getTransferEncoding() {
                return "binary";
            }

            public long getContentLength() {
                return -1L;
            }
        });
        partBuilder.setField("Content-Disposition", "inline;name=\"request\"");
        partBuilder.setField("Content-ID", "request");
        builder.addPart(partBuilder.build());
        partBuilder = FormBodyPartBuilder.create((String)"content", (ContentBody)new InputStreamBody(request.getContentBytes(), ContentType.parse((String)request.getContentType())));
        partBuilder.setField("Content-Disposition", "inline;name=\"content\"");
        partBuilder.setField("Content-ID", "content");
        builder.addPart(partBuilder.build());
        builder.setCharset(StandardCharsets.UTF_8);
        HttpEntity entity = builder.build();
        post.setEntity(entity);
    }

    private String headerValueOrNull(Header header) {
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    /*
     * Exception decompiling
     */
    private <T extends Response> T getResponse(HttpResponse httpResponse, Class<T> clazz) throws IOException, RosetteAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static byte[] getBytes(InputStream is) throws IOException {
        int size = 1024;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            int len;
            byte[] buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            byte[] byArray = buf = bos.toByteArray();
            return byArray;
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

