/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util;

import com.basistech.util.ISO15924;
import java.util.HashMap;
import java.util.Map;

public enum LanguageCode {
    UNKNOWN(0, "xxx", "xx", "Unknown", ISO15924.Zyyy),
    AFRIKAANS(75, "afr", "af", "Afrikaans", ISO15924.Latn),
    ALBANIAN(1, "sqi", "sq", "Albanian", ISO15924.Latn),
    AMHARIC(62, "amh", "am", "Amharic", ISO15924.Ethi),
    ARABIC(2, "ara", "ar", "Arabic", ISO15924.Arab),
    BENGALI(3, "ben", "bn", "Bengali", ISO15924.Beng),
    BULGARIAN(4, "bul", "bg", "Bulgarian", ISO15924.Cyrl),
    CATALAN(5, "cat", "ca", "Catalan", ISO15924.Latn),
    CHINESE(6, "zho", "zh", "Chinese", ISO15924.Hani),
    CROATIAN(7, "hrv", "hr", "Croatian", ISO15924.Latn),
    CZECH(8, "ces", "cs", "Czech", ISO15924.Latn),
    DANISH(9, "dan", "da", "Danish", ISO15924.Latn),
    DARI(60, "prs", "zz", "Dari", ISO15924.Arab),
    DUTCH(10, "nld", "nl", "Dutch", ISO15924.Latn),
    ENGLISH(11, "eng", "en", "English", ISO15924.Latn),
    ENGLISH_UPPERCASE(59, "uen", "en_uc", "English Uppercase", ISO15924.Latn),
    ESTONIAN(12, "est", "et", "Estonian", ISO15924.Latn),
    FINNISH(13, "fin", "fi", "Finnish", ISO15924.Latn),
    FRENCH(14, "fra", "fr", "French", ISO15924.Latn),
    GERMAN(15, "deu", "de", "German", ISO15924.Latn),
    GREEK(16, "ell", "el", "Greek", ISO15924.Grek),
    GUJARATI(17, "guj", "gu", "Gujarati", ISO15924.Gujr),
    HEBREW(18, "heb", "he", "Hebrew", ISO15924.Hebr),
    HINDI(19, "hin", "hi", "Hindi", ISO15924.Deva),
    HUNGARIAN(20, "hun", "hu", "Hungarian", ISO15924.Latn),
    ICELANDIC(21, "isl", "is", "Icelandic", ISO15924.Latn),
    INDONESIAN(22, "ind", "id", "Indonesian", ISO15924.Latn),
    ITALIAN(23, "ita", "it", "Italian", ISO15924.Latn),
    JAPANESE(24, "jpn", "ja", "Japanese", ISO15924.Hani),
    KANNADA(25, "kan", "kn", "Kannada", ISO15924.Knda),
    KINYARWANDA(67, "kin", "rw", "Kinyarwanda", ISO15924.Latn),
    KOREAN(26, "kor", "ko", "Korean", ISO15924.Hang),
    KURDISH(27, "kur", "ku", "Kurdish", ISO15924.Arab),
    LATVIAN(28, "lav", "lv", "Latvian", ISO15924.Latn),
    LITHUANIAN(29, "lit", "lt", "Lithuanian", ISO15924.Latn),
    MACEDONIAN(30, "mkd", "mk", "Macedonian", ISO15924.Cyrl),
    MALAGASY(63, "mlg", "mg", "Malagasy", ISO15924.Latn),
    MALAY(31, "msa", "ms", "Malay", ISO15924.Latn),
    STANDARD_MALAY(83, "zsm", "ms_sd", "Malay, Standard", ISO15924.Latn),
    MALAYALAM(32, "mal", "ml", "Malayalam", ISO15924.Mlym),
    NORTH_KOREAN(84, "qkp", "ko_kp", "Korean, North", ISO15924.Hang),
    NORWEGIAN(33, "nor", "no", "Norwegian", ISO15924.Latn),
    NORWEGIAN_BOKMAL(34, "nob", "nb", "Norwegian Bokmal", ISO15924.Latn),
    NORWEGIAN_NYNORSK(35, "nno", "nn", "Norwegian Nynorsk", ISO15924.Latn),
    NYANJA(65, "nya", "ny", "Nyanja", ISO15924.Latn),
    PEDI(78, "nso", "zz", "Pedi", ISO15924.Latn),
    PERSIAN(37, "fas", "fa", "Persian", ISO15924.Arab),
    PLATEAU_MALAGASY(64, "plt", "zz", "Plateau Malagasy", ISO15924.Latn),
    POLISH(38, "pol", "pl", "Polish", ISO15924.Latn),
    PORTUGUESE(39, "por", "pt", "Portuguese", ISO15924.Latn),
    PUSHTO(36, "pus", "ps", "Pushto", ISO15924.Arab),
    ROMANIAN(40, "ron", "ro", "Romanian", ISO15924.Latn),
    RUNDI(66, "run", "rn", "Rundi", ISO15924.Latn),
    RUSSIAN(41, "rus", "ru", "Russian", ISO15924.Cyrl),
    SANGO(68, "sag", "sg", "Sango", ISO15924.Latn),
    SERBIAN(42, "srp", "sr", "Serbian", ISO15924.Zyyy),
    SESELWA_CREOLE_FRENCH(69, "crs", "zz", "Seselwa Creole French", ISO15924.Latn),
    SHONA(73, "sna", "sn", "Shona", ISO15924.Latn),
    SIMPLIFIED_CHINESE(43, "zhs", "zh_sc", "Chinese, Simplified", ISO15924.Hans),
    SLOVAK(44, "slk", "sk", "Slovak", ISO15924.Latn),
    SLOVENIAN(45, "slv", "sl", "Slovenian", ISO15924.Latn),
    SOMALI(46, "som", "so", "Somali", ISO15924.Latn),
    SOUTHERN_SOTHO(79, "sot", "st", "Southern Sotho", ISO15924.Latn),
    SOUTH_KOREAN(85, "qkr", "ko_kr", "Korean, South", ISO15924.Hang),
    SOUTH_NDEBELE(77, "nbl", "nr", "South Ndebele", ISO15924.Latn),
    SPANISH(47, "spa", "es", "Spanish", ISO15924.Latn),
    SWAHILI(70, "swa", "sw", "Swahili", ISO15924.Latn),
    SWATI(71, "ssw", "ss", "Swati", ISO15924.Latn),
    SWEDISH(48, "swe", "sv", "Swedish", ISO15924.Latn),
    TAGALOG(49, "tgl", "tl", "Tagalog", ISO15924.Latn),
    TAMIL(50, "tam", "ta", "Tamil", ISO15924.Taml),
    TELUGU(51, "tel", "te", "Telugu", ISO15924.Telu),
    THAI(52, "tha", "th", "Thai", ISO15924.Thai),
    TIGRINYA(72, "tir", "ti", "Tigrinya", ISO15924.Ethi),
    TRADITIONAL_CHINESE(53, "zht", "zh_tc", "Chinese, Traditional", ISO15924.Hant),
    TSONGA(82, "tso", "ts", "Tsonga", ISO15924.Latn),
    TSWANA(80, "tsn", "tn", "Tswana", ISO15924.Latn),
    TURKISH(54, "tur", "tr", "Turkish", ISO15924.Latn),
    UKRAINIAN(55, "ukr", "uk", "Ukrainian", ISO15924.Cyrl),
    URDU(56, "urd", "ur", "Urdu", ISO15924.Arab),
    UZBEK(57, "uzb", "uz", "Uzbek", ISO15924.Zyyy),
    VENDA(81, "ven", "ve", "Venda", ISO15924.Latn),
    VIETNAMESE(58, "vie", "vi", "Vietnamese", ISO15924.Latn),
    WESTERN_FARSI(61, "pes", "zz", "Western Farsi", ISO15924.Arab),
    XHOSA(76, "xho", "xh", "Xhosa", ISO15924.Latn),
    ZULU(74, "zul", "zu", "Zulu", ISO15924.Latn);

    private int id;
    private String iso3;
    private String iso1;
    private String name;
    private ISO15924 defaultScript;
    public static final String UNCODED_ISO639_1 = "zz";
    private static final int ISO639_1_CODE_LENGTH = 2;
    private static final int ISO639_1_BASIS_CODE_LENGTH = 5;
    private static Map<String, LanguageCode> iso639_1_index;
    private static Map<String, LanguageCode> iso639_3_index;
    private static int[] id_index;
    private static final float HASHMAP_DEFAULT_LOAD_FACTOR = 0.75f;

    private LanguageCode(int id, String iso3, String iso1, String name, ISO15924 defaultScript) {
        this.id = id;
        this.iso3 = iso3;
        this.iso1 = iso1;
        this.name = name;
        this.defaultScript = defaultScript;
    }

    public int languageID() {
        return this.id;
    }

    public String ISO639_1() {
        return this.iso1;
    }

    public String ISO639_3() {
        return this.iso3;
    }

    public ISO15924 getDefaultScript() {
        return this.defaultScript;
    }

    public String languageName() {
        return this.name;
    }

    int getNativeCode() {
        return this.id;
    }

    static LanguageCode lookupByNativeCode(int nativeCode) {
        if (nativeCode < 0 || LanguageCode.values().length <= nativeCode) {
            throw new IllegalArgumentException("Invalid Language ID native code " + nativeCode);
        }
        return LanguageCode.values()[id_index[nativeCode]];
    }

    public static boolean LanguageIDIsValid(int languageID) {
        try {
            LanguageCode.lookupByLanguageID(languageID);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static LanguageCode lookupByLanguageID(int languageID) {
        return LanguageCode.lookupByNativeCode(languageID);
    }

    public static boolean ISO639IsValid(String iso639) {
        try {
            LanguageCode.lookupByISO639(iso639);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static LanguageCode lookupByISO639(String iso639) {
        int size = iso639.length();
        LanguageCode result = null;
        result = size == 2 || size == 5 ? iso639_1_index.get(iso639) : iso639_3_index.get(iso639);
        if (result == null) {
            throw new IllegalArgumentException("Invalid ISO639 " + iso639);
        }
        return result;
    }

    public static LanguageCode normalizeNonStandard(LanguageCode lc) {
        switch (lc) {
            case SIMPLIFIED_CHINESE: 
            case TRADITIONAL_CHINESE: {
                return CHINESE;
            }
            case ENGLISH_UPPERCASE: {
                return ENGLISH;
            }
        }
        return lc;
    }

    static {
        int indexCapacity = (int)((float)LanguageCode.values().length / 0.75f);
        iso639_1_index = new HashMap<String, LanguageCode>(indexCapacity);
        iso639_3_index = new HashMap<String, LanguageCode>(indexCapacity);
        id_index = new int[LanguageCode.values().length];
        LanguageCode[] values = LanguageCode.values();
        int valuesIdx = 0;
        while (valuesIdx < values.length) {
            LanguageCode code = values[valuesIdx];
            if (!code.ISO639_1().equals(UNCODED_ISO639_1)) {
                iso639_1_index.put(code.ISO639_1(), code);
            }
            iso639_3_index.put(code.ISO639_3(), code);
            LanguageCode.id_index[code.languageID()] = valuesIdx++;
        }
    }
}

