/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util;

import com.basistech.util.NoRootDirectoryException;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;

public class Pathnames {
    private static String btRootDirectory;

    public static void setBTRootDirectory(String path) {
        btRootDirectory = path;
    }

    static void reset() {
        btRootDirectory = null;
    }

    static String binOrLib() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "bin" : "lib";
    }

    static String debugSuffix() {
        return System.getProperty("debug.level", "").equals("2") ? "_g" : "";
    }

    String getLibraryParentDir() {
        return this.getBTRootDirectory() + "/rlp/" + Pathnames.binOrLib() + Pathnames.debugSuffix();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getPlatform() {
        Object dir;
        String s = System.getProperty("bt.arch");
        if (s == null) {
            dir = this.getLibraryParentDir();
            File[] platformDirs = new File((String)dir).listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() & !f.isHidden();
                }
            });
            if (platformDirs == null || platformDirs.length == 0) {
                throw new IllegalStateException(MessageFormat.format("\"{0}\" has no platform subdirectories.  This may be the result of an incorrect setting of bt.root.", dir));
            }
            if (platformDirs.length != 1) throw new IllegalStateException(MessageFormat.format("Multiple platform subdirectories found under \"{0}\".  bt.arch system property is required.", dir));
            s = platformDirs[0].getName();
        } else if (s.trim().length() == 0) {
            throw new IllegalStateException("bt.arch system property cannot be blank.");
        }
        if (((File)(dir = new File(this.getLibraryParentDir() + File.separator + s))).isDirectory()) return s;
        throw new IllegalStateException(MessageFormat.format("\"{0}\" is not a directory.  This may be the result of an incorrect setting of bt.root or bt.arch.", dir));
    }

    public String getBTRootDirectory() {
        if (btRootDirectory != null) {
            return btRootDirectory;
        }
        String r = System.getProperty("bt.root", null);
        if (r == null || r.length() == 0) {
            throw new NoRootDirectoryException();
        }
        return r;
    }

    public String getJNIModuleDirectory() {
        return this.getLibraryParentDir() + File.separator + this.getPlatform();
    }
}

