/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util;

import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import com.basistech.util.TransliterationScheme;
import java.io.Serializable;
import java.util.Objects;

public class TextDomain
implements Serializable,
Comparable<TextDomain> {
    private ISO15924 theScript;
    private LanguageCode theLanguage;
    private TransliterationScheme theScheme;

    public TextDomain(ISO15924 script, LanguageCode language, TransliterationScheme scheme) {
        this.theScript = script == null ? ISO15924.Zyyy : script;
        this.theLanguage = language == null ? LanguageCode.UNKNOWN : language;
        this.theScheme = scheme == null ? TransliterationScheme.UNKNOWN : scheme;
    }

    public TextDomain(LanguageCode language) {
        if (language == null) {
            language = LanguageCode.UNKNOWN;
        }
        this.theScript = language.getDefaultScript();
        this.theLanguage = language;
        this.theScheme = TransliterationScheme.UNKNOWN;
    }

    TextDomain() {
        this.theScript = ISO15924.Zyyy;
        this.theLanguage = LanguageCode.UNKNOWN;
        this.theScheme = TransliterationScheme.UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextDomain that = (TextDomain)o;
        return this.theScript == that.theScript && this.theLanguage == that.theLanguage && this.theScheme == that.theScheme;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.theScript, this.theLanguage, this.theScheme});
    }

    public ISO15924 getScript() {
        return this.theScript;
    }

    @Deprecated
    void setScript(ISO15924 script) {
        this.theScript = script == null ? ISO15924.Zyyy : script;
    }

    public LanguageCode getLanguage() {
        return this.theLanguage;
    }

    @Deprecated
    void setLanguage(LanguageCode lang) {
        this.theLanguage = lang == null ? LanguageCode.UNKNOWN : lang;
    }

    public TransliterationScheme getTransliterationScheme() {
        return this.theScheme;
    }

    @Deprecated
    void setTransliterationScheme(TransliterationScheme scheme) {
        this.theScheme = scheme == null ? TransliterationScheme.UNKNOWN : scheme;
    }

    public String toString() {
        return "[" + this.theScript.code4() + "/" + this.theLanguage.ISO639_3() + "/" + this.theScheme.getName() + "]";
    }

    @Override
    public int compareTo(TextDomain o) {
        int otherN;
        int n = this.theScript.numeric();
        if (n > (otherN = o.getScript().numeric())) {
            return 1;
        }
        if (n < otherN) {
            return -1;
        }
        n = this.theLanguage.languageID();
        if (n > (otherN = o.getLanguage().languageID())) {
            return 1;
        }
        if (n < otherN) {
            return -1;
        }
        n = this.theScheme.getNativeCode();
        if (n > (otherN = o.getTransliterationScheme().getNativeCode())) {
            return 1;
        }
        if (n < otherN) {
            return -1;
        }
        return 0;
    }
}

