/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.util;

import java.util.HashMap;

public enum TransliterationScheme {
    FBIS(0, "fbis", "FBIS", "US Foreign Broadcast Information Service"),
    BGN(1, "bgn", "BGN", "US Board on Geographic Names"),
    BASIS(2, "basis", "Basis", "Basis Technology Corp."),
    IC(3, "ic", "IC", "US Intelligence Community"),
    SATTS(4, "satts", "SATTS", "Standard Arabic Technical Transliteration System"),
    BUCKWALTER(5, "buckwalter", "Buckwalter", "Tim Buckwalter/Qamus"),
    UNRSGN(6, "unrsgn", "UNRSGN", "United Nations Romanization System for Geographic Names"),
    ALA_LC(7, "ala_lc", "Library of Congress", "American Library Association/Library of Congress Transliteration"),
    IGN(8, "ign", "I.G.N. System 1973", "Also called Variant B of the Amended Beirut System"),
    RJGC(9, "rjgc", "Royal Jordanian Geographic Centre System", "Essentially the same as the amended Beirut system. The sub-macron is used instead of the cedilla."),
    ISO233_1984(10, "iso233_1984", "ISO 233:1984", "Gives every character and diacritical mark a unique equivalent."),
    SES(11, "ses", "Survey of Egypt System", "Survey of Egypt System."),
    DMG(12, "dmg", "Deutsche Morgenlandishe Gesellschaft", ""),
    EI(13, "ei", "Encyclopedia of Islam", ""),
    KNAB(14, "knab", "Kohanimeandmebaas", ""),
    ALLWORTH(15, "allworth", "Allworth", ""),
    ISO9_1995(16, "iso9_1995", "ISO 9:1995", ""),
    WWS(17, "wws", "The World's Writing Systems", ""),
    JDEC_AF(18, "jdec_af", "JDEC - Afghanistan", "Joint Document Exploitation Center - Afghanistan"),
    MELTS(19, "melts", "MELTS", "Middle East Languages Transliteration Standard"),
    ISO233_2_1993(20, "iso233_2_1993", "ISO 233-2:1993", "Establishes a simplified system vs the stringent rules established by ISO 233:1984 for Arabic."),
    ISO233_3_1999(21, "iso233_3_1999", "ISO 233-3:1999", "ISO 233 Part 3, for Persian"),
    WIKIPEDIA_ASCII(22, "wikipedia_ascii", "ASCII-limited Transliteration Scheme used in Wikipedia", "ASCII restricted; possibly a variation on more formal transliteration schemes."),
    ELOT743(23, "elot743", "ELOT 743", " Romanization system for Greek"),
    ISO843_1997(24, "iso843_1997", "ISO 843:1997", "Romanization of the Greek alphabet"),
    ISO259_1984(25, "iso259_1984", "ISO 259:1984", "Transliteration of Hebrew characters into Latin characters"),
    ISO259_2_1994(26, "iso259_2_1994", "ISO 259-2:1994", "Transliteration of Hebrew characters into Latin characters"),
    ANSIZ39_25_1975(27, "ansiz39_25_1975", "ANSI Z39.25-1975", "Transliteration of Hebrew"),
    ASCII(99, "ascii", "ASCII subset of Latin Script", "Custom scheme to Basis for transliterating characters using a broader portion of the Latin Script to solely ASCII, based on removing diacritics and using the closest letter visually."),
    IC_BGN(100, "ic_bgn", "IC (+BGN for places)", "IC for everything but places, BGN for those"),
    UND_BGN(101, "und_bgn", "Undiacritized BGN", "US Board on Geographic Names - diacritics removed"),
    EXT_IC(102, "ext_ic", "Extended IC", "US Intelligence Community - extended"),
    ICU(103, "icu", "ICU", "Transliteration library provided with the International Components for Unicode library"),
    BASIS_DIA(199, "basis_dia", "Basis Diacritization", "Diacritization according to a private-use standard by Basis Technology Corp."),
    KORDA(200, "korda", "KORDA", "Korean Romanization for Data Applications"),
    MORSE(201, "morse", "Morse", "Morse"),
    YALE(202, "yale", "Yale", "Yale"),
    MCR(203, "mcr", "McCune-Reischauer", "McCune-Reischauer"),
    LUKOFF(204, "lukoff", "Lukoff", "Lukoff"),
    SK(205, "sk", "2959-SK", "2959-SK, Developed by South Korea's Ministry of Education"),
    JG(206, "jg", "Joseon Gwahagwon", "Joseon Gwahagwon"),
    MOCT(207, "moct", "Revised Romanization of Korean", "2000 Revised Romanization of Korean by Ministry of Culture and Tourism"),
    HYPY(300, "hypy", "Pinyin", "Hanyu Pinyin (without tone annotations)"),
    HYPY_TONED(301, "hypy_toned", "Hanyu Pinyin Toned", "Hanyu Pinyin with tone annotations"),
    WADE_GILES(302, "wade_giles", "Wade-Giles", "Wade-Giles"),
    TYPY(303, "typy", "Tongyong Pinyin", "Tongyong  Pinyin (without tone annotations)"),
    TYPY_TONED(304, "typy_toned", "Tongyong Pinyin Toned", "Tongyong Pinyin with tone annotations"),
    ZWPY(305, "zwpy", "Zongwen (Tibetan) Pinyin", "Zongwen (Tibetan) Pinyin"),
    CTPY(306, "ctpy", "Cantonese Pinyin", "Standard Cantonese Pinyin"),
    POJ(307, "poj", "POJ", "Peh-oe-ji (POJ)"),
    GAUNGDONG(308, "gaungdong", "Guangdong Romanization", "Guangdong Romanization"),
    CTC(309, "ctc", "Chinese Telegraph Code", "Chinese Telegraph Code"),
    ISO_11940(310, "iso_11940", "ISO :11940", "DEPRECATED; use ISO11940_1998. Romanization of the Thai"),
    ISO_11940_2(311, "iso_11940_2", "ISO :11940-2", "DEPRECATED; use ISO11940_2_2007. Romanization of Thai alphabet"),
    RTGS(312, "rtgs", "RTGS", " Royal Thai General System of Transcription"),
    ISO11940_1998(313, "iso11940_1998", "ISO 11940:1998", "Transliteration of Thai characters into Latin characters"),
    ISO11940_2_2007(314, "iso11940_2_2007", "ISO 11940-2:2007", "Transliteration of Thai characters into Latin characters"),
    HEBON(400, "hebon", "Hebon Romaji", "Hebon-shiki Romaji (or Hepburn) scheme for Japanese"),
    KUNREI(401, "kunrei", "Kunrei-shiki Romaji", "Kunrei-shiki Romaji scheme for Japanese"),
    ISCII(500, "iscii", "ISCII", "Indian Script Code for Information Interchange"),
    PASCII(501, "pascii", "PASCII", "Perso-Arabic Script Code for Information Interchange"),
    ARABTEX(502, "arabtex", "ArabTeX", ""),
    LSI(503, "lsi", "Linguistic Survey of India", ""),
    NCC(600, "ncc", "National Cartography Center (NCC) of Iran", "The Transliteration/Transcription system of the National Cartography Center (NCC) of Iran."),
    PRIVATE_USE(1996, "private_use", "Private use", "Private use"),
    FOLK(1997, "folk", "Folk", "Folk"),
    UNKNOWN(1998, "unknown", "Unknown", "Unknown"),
    NATIVE(1999, "native", "Native", "Native");

    private final int BT_Xlit_Scheme;
    private final String name;
    private final String presentationName;
    private final String description;

    private TransliterationScheme(int BT_Xlit_Scheme, String name, String presentationName, String description) {
        this.BT_Xlit_Scheme = BT_Xlit_Scheme;
        this.name = name;
        this.presentationName = presentationName;
        this.description = description;
    }

    public static TransliterationScheme getObjectByBT_Xlit_Scheme(int BT_Xlit_Scheme) {
        TransliterationScheme ts = (TransliterationScheme)((Object)CatalogByBTXlitScheme.it.get(BT_Xlit_Scheme));
        if (ts == null) {
            throw new IllegalArgumentException("Unknown BT_Xlit_Scheme code: " + BT_Xlit_Scheme);
        }
        return ts;
    }

    static TransliterationScheme lookupByNativeCode(int nativeCode) {
        return TransliterationScheme.getObjectByBT_Xlit_Scheme(nativeCode);
    }

    public int getNativeCode() {
        return this.BT_Xlit_Scheme;
    }

    public static TransliterationScheme getObjectByName(String name) {
        TransliterationScheme ts = (TransliterationScheme)((Object)CatalogByName.it.get(name));
        if (ts == null) {
            throw new IllegalArgumentException("Unknown TransliterationScheme name: " + name);
        }
        return ts;
    }

    public String getName() {
        return this.name;
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public String getDescription() {
        return this.description;
    }

    private static class CatalogByName {
        private static HashMap<String, TransliterationScheme> it = new HashMap();

        private CatalogByName() {
        }

        static {
            for (TransliterationScheme t : TransliterationScheme.values()) {
                it.put(t.name, t);
            }
        }
    }

    private static class CatalogByBTXlitScheme {
        private static final HashMap<Integer, TransliterationScheme> it = new HashMap();

        private CatalogByBTXlitScheme() {
        }

        static {
            for (TransliterationScheme t : TransliterationScheme.values()) {
                it.put(t.BT_Xlit_Scheme, t);
            }
        }
    }
}

