/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.api;

import com.basistech.rosette.RosetteRuntimeException;
import com.basistech.rosette.api.HttpRosetteAPIException;
import com.basistech.rosette.api.common.AbstractRosetteAPI;
import com.basistech.rosette.apimodel.AdmRequest;
import com.basistech.rosette.apimodel.AdmResponse;
import com.basistech.rosette.apimodel.DocumentRequest;
import com.basistech.rosette.apimodel.InfoResponse;
import com.basistech.rosette.apimodel.PingResponse;
import com.basistech.rosette.apimodel.Request;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.apimodel.SupportedLanguagePairsResponse;
import com.basistech.rosette.apimodel.SupportedLanguagesResponse;
import com.basistech.rosette.apimodel.jackson.ApiModelMixinModule;
import com.basistech.rosette.apimodel.jackson.DocumentRequestMixin;
import com.basistech.rosette.dm.AnnotatedText;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRosetteAPI
extends AbstractRosetteAPI {
    public static final String DEFAULT_URL_BASE = "https://api.rosette.com/rest/v1";
    public static final String SERVICE_NAME = "RosetteAPI";
    public static final String BINDING_VERSION = HttpRosetteAPI.getVersion();
    public static final String USER_AGENT_STR = "RosetteAPI-Java/" + BINDING_VERSION + "/" + System.getProperty("java.version");
    private static final Logger LOG = LoggerFactory.getLogger(HttpRosetteAPI.class);
    private String urlBase = "https://api.rosette.com/rest/v1";
    private int failureRetries = 1;
    private ObjectMapper mapper;
    private CloseableHttpClient httpClient;
    private List<Header> additionalHeaders;
    private int connectionConcurrency = 2;
    private boolean closeClientOnClose = true;

    private HttpRosetteAPI() {
    }

    HttpRosetteAPI(String key, String urlToCall, Integer failureRetries, CloseableHttpClient httpClient, List<Header> additionalHeaders, Integer connectionConcurrency, boolean onlyAcceptKnownFields) throws HttpRosetteAPIException {
        String string = this.urlBase = urlToCall == null ? this.urlBase : urlToCall.trim().replaceAll("/+$", "");
        if (failureRetries != null && failureRetries >= 1) {
            this.failureRetries = failureRetries;
        }
        if (connectionConcurrency != null) {
            this.connectionConcurrency = connectionConcurrency;
        }
        this.mapper = ApiModelMixinModule.setupObjectMapper((ObjectMapper)new ObjectMapper());
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, onlyAcceptKnownFields);
        if (httpClient == null) {
            this.initClient(key, additionalHeaders);
        } else {
            this.httpClient = httpClient;
            this.initHeaders(key, additionalHeaders);
            this.closeClientOnClose = false;
        }
    }

    private static String getVersion() {
        Properties properties = new Properties();
        try (InputStream ins = HttpRosetteAPI.class.getClassLoader().getResourceAsStream("version.properties");){
            properties.load(ins);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties.getProperty("version", "undefined");
    }

    private static byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while (true) {
            int r;
            if ((r = is.read(buf)) == -1) {
                out.flush();
                return out.toByteArray();
            }
            out.write(buf, 0, r);
        }
    }

    private void initClient(String key, List<Header> additionalHeaders) {
        HttpClientBuilder builder = HttpClients.custom();
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.connectionConcurrency);
        builder.setConnectionManager((HttpClientConnectionManager)cm);
        this.initHeaders(key, additionalHeaders);
        builder.setDefaultHeaders(this.additionalHeaders);
        this.httpClient = builder.build();
        this.additionalHeaders = new ArrayList<Header>();
    }

    private void initHeaders(String key, List<Header> additionalHeaders) {
        this.additionalHeaders = new ArrayList<Header>();
        this.additionalHeaders.add((Header)new BasicHeader("User-Agent", USER_AGENT_STR));
        this.additionalHeaders.add((Header)new BasicHeader("Accept-Encoding", "gzip"));
        if (key != null) {
            this.additionalHeaders.add((Header)new BasicHeader("X-RosetteAPI-Key", key));
            this.additionalHeaders.add((Header)new BasicHeader("X-RosetteAPI-Binding", "java"));
            this.additionalHeaders.add((Header)new BasicHeader("X-RosetteAPI-Binding-Version", BINDING_VERSION));
        }
        if (additionalHeaders != null) {
            this.additionalHeaders.addAll(additionalHeaders);
        }
    }

    public int getFailureRetries() {
        return this.failureRetries;
    }

    public InfoResponse info() throws IOException, HttpRosetteAPIException {
        return this.sendGetRequest(this.urlBase + "/info", InfoResponse.class);
    }

    public PingResponse ping() throws IOException, HttpRosetteAPIException {
        return this.sendGetRequest(this.urlBase + "/ping", PingResponse.class);
    }

    public SupportedLanguagesResponse getSupportedLanguages(String endpoint) throws HttpRosetteAPIException {
        if (DOC_ENDPOINTS.contains(endpoint) || "/name-deduplication".equals(endpoint)) {
            return this.sendGetRequest(this.urlBase + endpoint + "/supported-languages", SupportedLanguagesResponse.class);
        }
        return null;
    }

    public SupportedLanguagePairsResponse getSupportedLanguagePairs(String endpoint) throws HttpRosetteAPIException {
        if (NAMES_ENDPOINTS.contains(endpoint) && !"/name-deduplication".equals(endpoint)) {
            return this.sendGetRequest(this.urlBase + endpoint + "/supported-languages", SupportedLanguagePairsResponse.class);
        }
        return null;
    }

    public <RequestType extends Request, ResponseType extends Response> ResponseType perform(String endpoint, RequestType request, Class<ResponseType> responseClass) throws HttpRosetteAPIException {
        try {
            return (ResponseType)((Response)this.sendPostRequest(request, this.urlBase + endpoint, responseClass));
        }
        catch (IOException e) {
            throw new RosetteRuntimeException("IO Exception communicating with the Rosette API", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new RosetteRuntimeException("Invalid URI", (Throwable)e);
        }
    }

    public <RequestType extends Request> AnnotatedText perform(String endpoint, RequestType request) throws HttpRosetteAPIException {
        try {
            return this.sendPostRequest(request, this.urlBase + endpoint, AnnotatedText.class);
        }
        catch (IOException e) {
            throw new RosetteRuntimeException("IO Exception communicating with the Rosette API", (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new RosetteRuntimeException("Invalid URI", (Throwable)e);
        }
    }

    public <RequestType extends Request, ResponseType extends Response> Future<ResponseType> performAsync(String endpoint, RequestType request, Class<ResponseType> responseClass) throws HttpRosetteAPIException {
        throw new UnsupportedOperationException("Asynchronous operations are not yet supported");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T extends Response> T sendGetRequest(String urlStr, Class<T> clazz) throws HttpRosetteAPIException {
        HttpGet get = new HttpGet(urlStr);
        for (Header header : this.additionalHeaders) {
            get.addHeader(header);
        }
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)get);){
            Response resp = (Response)this.getResponse((HttpResponse)httpResponse, clazz);
            this.responseHeadersToExtendedInformation(resp, (HttpResponse)httpResponse);
            Response response = resp;
            return (T)response;
        }
        catch (IOException e) {
            throw new RosetteRuntimeException("IO Exception communicating with the Rosette API", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T sendPostRequest(Object request, String urlStr, Class<T> clazz) throws IOException, URISyntaxException {
        boolean notPlainText;
        ObjectWriter writer;
        block27: {
            block26: {
                writer = this.mapper.writer().without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
                notPlainText = false;
                if (!(request instanceof DocumentRequest)) break block26;
                Object rawContent = ((DocumentRequest)request).getRawContent();
                if (rawContent instanceof String) {
                    writer = writer.withView(DocumentRequestMixin.Views.Content.class);
                    break block27;
                } else if (rawContent != null) {
                    notPlainText = true;
                }
                break block27;
            }
            if (request instanceof AdmRequest) {
                notPlainText = true;
            }
        }
        URIBuilder uriBuilder = new URIBuilder(urlStr);
        if (AnnotatedText.class.isAssignableFrom(clazz) || AdmResponse.class.equals(clazz)) {
            uriBuilder.addParameter("output", "rosette");
        }
        ObjectWriter finalWriter = writer;
        HttpPost post = new HttpPost(uriBuilder.build());
        for (Header header : this.additionalHeaders) {
            post.addHeader(header);
        }
        if (notPlainText) {
            this.setupMultipartRequest((Request)request, finalWriter, post);
        } else {
            this.setupPlainRequest(request, finalWriter, post);
        }
        HttpRosetteAPIException lastException = null;
        int numRetries = this.failureRetries;
        while (numRetries-- > 0) {
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                T resp = this.getResponse((HttpResponse)response, clazz);
                Header ridHeader = response.getFirstHeader("X-RosetteAPI-DocumentRequest-Id");
                if (ridHeader != null && ridHeader.getValue() != null) {
                    LOG.debug("DocumentRequest ID " + ridHeader.getValue());
                }
                if (resp instanceof Response) {
                    this.responseHeadersToExtendedInformation((Response)resp, (HttpResponse)response);
                }
                T t = resp;
                return t;
            }
            catch (HttpRosetteAPIException e) {
                if (e.getHttpStatusCode() < 500) {
                    throw e;
                }
                lastException = e;
            }
        }
        throw lastException;
    }

    private <T extends Response> void responseHeadersToExtendedInformation(T resp, HttpResponse response) {
        for (Header header : response.getAllHeaders()) {
            if (resp.getExtendedInformation() != null && resp.getExtendedInformation().containsKey(header.getName())) {
                HashSet currentSetValue = resp.getExtendedInformation().get(header.getName()) instanceof Set ? (HashSet)resp.getExtendedInformation().get(header.getName()) : new HashSet(Collections.singletonList(resp.getExtendedInformation().get(header.getName())));
                currentSetValue.add(header.getValue());
                resp.addExtendedInformation(header.getName(), currentSetValue);
                continue;
            }
            resp.addExtendedInformation(header.getName(), (Object)header.getValue());
        }
    }

    private void setupPlainRequest(final Object request, final ObjectWriter finalWriter, HttpPost post) {
        post.addHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
        post.setEntity((HttpEntity)new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return false;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IOException, UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            public void writeTo(OutputStream outstream) throws IOException {
                finalWriter.writeValue(outstream, request);
            }

            public boolean isStreaming() {
                return false;
            }
        });
    }

    private void setupMultipartRequest(final Request request, final ObjectWriter finalWriter, HttpPost post) throws IOException {
        InputStreamBody insBody;
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMimeSubtype("mixed");
        builder.setMode(HttpMultipartMode.STRICT);
        FormBodyPartBuilder partBuilder = FormBodyPartBuilder.create((String)"request", (ContentBody)new AbstractContentBody(ContentType.parse((String)ContentType.APPLICATION_JSON.getMimeType())){

            public String getFilename() {
                return null;
            }

            public void writeTo(OutputStream out) throws IOException {
                finalWriter.writeValue(out, (Object)request);
            }

            public String getTransferEncoding() {
                return "binary";
            }

            public long getContentLength() {
                return -1L;
            }
        });
        partBuilder.setField("Content-Disposition", "inline;name=\"request\"");
        partBuilder.setField("Content-ID", "request");
        builder.addPart(partBuilder.build());
        if (request instanceof DocumentRequest) {
            DocumentRequest docReq = (DocumentRequest)request;
            insBody = new InputStreamBody(docReq.getContentBytes(), ContentType.parse((String)docReq.getContentType()));
        } else if (request instanceof AdmRequest) {
            AdmRequest admReq = (AdmRequest)request;
            ObjectWriter writer = this.mapper.writer().without(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            byte[] json = writer.writeValueAsBytes((Object)admReq.getText());
            insBody = new ByteArrayBody(json, ContentType.parse((String)"model/vnd.rosette.annotated-data-model"), null);
        } else {
            throw new UnsupportedOperationException("Unsupported request type for multipart processing");
        }
        partBuilder = FormBodyPartBuilder.create((String)"content", (ContentBody)insBody);
        partBuilder.setField("Content-Disposition", "inline;name=\"content\"");
        partBuilder.setField("Content-ID", "content");
        builder.addPart(partBuilder.build());
        builder.setCharset(StandardCharsets.UTF_8);
        HttpEntity entity = builder.build();
        post.setEntity(entity);
    }

    private String headerValueOrNull(Header header) {
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    /*
     * Exception decompiling
     */
    private <T> T getResponse(HttpResponse httpResponse, Class<T> clazz) throws IOException, HttpRosetteAPIException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() throws IOException {
        if (this.closeClientOnClose) {
            this.httpClient.close();
        }
    }

    public static class Builder {
        private String key;
        private String url;
        private Integer failureRetries;
        private Integer concurrency;
        private CloseableHttpClient httpClient;
        private List<Header> additionalHeaders = new ArrayList<Header>();
        private boolean onlyAcceptKnownFields;

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder failureRetries(Integer failureRetries) {
            this.failureRetries = failureRetries;
            return this;
        }

        public Builder connectionConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        public Builder httpClient(CloseableHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder additionalHeader(String name, String value) {
            this.additionalHeaders.add((Header)new BasicHeader(name, value));
            return this;
        }

        public Builder onlyAcceptKnownFields(boolean onlyAcceptKnownFields) {
            this.onlyAcceptKnownFields = onlyAcceptKnownFields;
            return this;
        }

        public HttpRosetteAPI build() throws HttpRosetteAPIException {
            return new HttpRosetteAPI(this.key, this.url, this.failureRetries, this.httpClient, this.additionalHeaders, this.concurrency, this.onlyAcceptKnownFields);
        }
    }
}

