/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.rosette.apimodel.Options;
import com.basistech.rosette.apimodel.Request;
import com.basistech.rosette.dm.AnnotatedText;
import com.basistech.util.LanguageCode;

public final class AdmRequest<O extends Options>
extends Request {
    public static final String ADM_CONTENT_TYPE = "model/vnd.rosette.annotated-data-model";
    private final AnnotatedText text;
    private final O options;
    private final String genre;
    private final LanguageCode language;

    public AdmRequest(String profileId, AnnotatedText text, O options, String genre, LanguageCode language) {
        super(profileId);
        this.text = text;
        this.options = options;
        this.genre = genre;
        this.language = language;
    }

    public static <O extends Options> AdmRequestBuilder<O> builder() {
        return new AdmRequestBuilder();
    }

    public AnnotatedText getText() {
        return this.text;
    }

    public O getOptions() {
        return this.options;
    }

    public String getGenre() {
        return this.genre;
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdmRequest)) {
            return false;
        }
        AdmRequest other = (AdmRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotatedText this$text = this.getText();
        AnnotatedText other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        O this$options = this.getOptions();
        O other$options = other.getOptions();
        if (this$options == null ? other$options != null : !this$options.equals(other$options)) {
            return false;
        }
        String this$genre = this.getGenre();
        String other$genre = other.getGenre();
        if (this$genre == null ? other$genre != null : !this$genre.equals(other$genre)) {
            return false;
        }
        LanguageCode this$language = this.getLanguage();
        LanguageCode other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AdmRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        AnnotatedText $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        O $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        String $genre = this.getGenre();
        result = result * 59 + ($genre == null ? 43 : $genre.hashCode());
        LanguageCode $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AdmRequest(text=" + this.getText() + ", options=" + this.getOptions() + ", genre=" + this.getGenre() + ", language=" + this.getLanguage() + ")";
    }

    public static class AdmRequestBuilder<O extends Options> {
        private String profileId;
        private AnnotatedText text;
        private O options;
        private String genre;
        private LanguageCode language;

        AdmRequestBuilder() {
        }

        public AdmRequestBuilder<O> profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public AdmRequestBuilder<O> text(AnnotatedText text) {
            this.text = text;
            return this;
        }

        public AdmRequestBuilder<O> options(O options) {
            this.options = options;
            return this;
        }

        public AdmRequestBuilder<O> genre(String genre) {
            this.genre = genre;
            return this;
        }

        public AdmRequestBuilder<O> language(LanguageCode language) {
            this.language = language;
            return this;
        }

        public AdmRequest<O> build() {
            return new AdmRequest<O>(this.profileId, this.text, this.options, this.genre, this.language);
        }

        public String toString() {
            return "AdmRequest.AdmRequestBuilder(profileId=" + this.profileId + ", text=" + this.text + ", options=" + this.options + ", genre=" + this.genre + ", language=" + this.language + ")";
        }
    }
}

