/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.rosette.apimodel.Options;
import com.basistech.rosette.apimodel.Request;
import com.basistech.util.LanguageCode;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class DocumentRequest<O extends Options>
extends Request {
    private final LanguageCode language;
    private final Object content;
    private final String contentUri;
    private final String contentType;
    private final String genre;
    private final O options;

    public DocumentRequest(String profileId, LanguageCode language, Object content, String contentUri, String contentType, String genre, O options) {
        super(profileId);
        this.language = language;
        this.content = content;
        this.contentUri = contentUri;
        this.contentType = contentType;
        this.genre = genre;
        this.options = options;
    }

    public String getContent() {
        if (this.content instanceof String) {
            return (String)this.content;
        }
        return null;
    }

    public InputStream getContentBytes() {
        if (this.content instanceof InputStream) {
            return (InputStream)this.content;
        }
        return null;
    }

    public Object getRawContent() {
        return this.content;
    }

    public static <O extends Options> DocumentRequestBuilder<O> builder() {
        return new DocumentRequestBuilder();
    }

    public LanguageCode getLanguage() {
        return this.language;
    }

    public String getContentUri() {
        return this.contentUri;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getGenre() {
        return this.genre;
    }

    public O getOptions() {
        return this.options;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentRequest)) {
            return false;
        }
        DocumentRequest other = (DocumentRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LanguageCode this$language = this.getLanguage();
        LanguageCode other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$contentUri = this.getContentUri();
        String other$contentUri = other.getContentUri();
        if (this$contentUri == null ? other$contentUri != null : !this$contentUri.equals(other$contentUri)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        String this$genre = this.getGenre();
        String other$genre = other.getGenre();
        if (this$genre == null ? other$genre != null : !this$genre.equals(other$genre)) {
            return false;
        }
        O this$options = this.getOptions();
        O other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !this$options.equals(other$options));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DocumentRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        LanguageCode $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $contentUri = this.getContentUri();
        result = result * 59 + ($contentUri == null ? 43 : $contentUri.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        String $genre = this.getGenre();
        result = result * 59 + ($genre == null ? 43 : $genre.hashCode());
        O $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : $options.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DocumentRequest(language=" + this.getLanguage() + ", content=" + this.getContent() + ", contentUri=" + this.getContentUri() + ", contentType=" + this.getContentType() + ", genre=" + this.getGenre() + ", options=" + this.getOptions() + ")";
    }

    public static class DocumentRequestBuilder<O extends Options> {
        private String profileId;
        private LanguageCode language;
        private Object content;
        private String contentUri;
        private String contentType;
        private String genre;
        private O options;

        public DocumentRequestBuilder<O> content(String data) {
            this.content = data;
            return this;
        }

        public DocumentRequestBuilder<O> content(byte[] bytes, String contentType) {
            this.content = new ByteArrayInputStream(bytes);
            this.contentType = contentType;
            return this;
        }

        public DocumentRequestBuilder<O> content(InputStream bytes, String contentType) {
            this.content = bytes;
            this.contentType = contentType;
            return this;
        }

        DocumentRequestBuilder() {
        }

        public DocumentRequestBuilder<O> profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public DocumentRequestBuilder<O> language(LanguageCode language) {
            this.language = language;
            return this;
        }

        public DocumentRequestBuilder<O> contentUri(String contentUri) {
            this.contentUri = contentUri;
            return this;
        }

        public DocumentRequestBuilder<O> contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public DocumentRequestBuilder<O> genre(String genre) {
            this.genre = genre;
            return this;
        }

        public DocumentRequestBuilder<O> options(O options) {
            this.options = options;
            return this;
        }

        public DocumentRequest<O> build() {
            return new DocumentRequest<O>(this.profileId, this.language, this.content, this.contentUri, this.contentType, this.genre, this.options);
        }

        public String toString() {
            return "DocumentRequest.DocumentRequestBuilder(profileId=" + this.profileId + ", language=" + this.language + ", content=" + this.content + ", contentUri=" + this.contentUri + ", contentType=" + this.contentType + ", genre=" + this.genre + ", options=" + this.options + ")";
        }
    }
}

