/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.apimodel;

import com.basistech.rosette.apimodel.LanguageWeight;
import com.basistech.rosette.apimodel.Options;
import com.basistech.rosette.util.EncodingCode;
import com.basistech.util.LanguageCode;
import java.beans.ConstructorProperties;
import java.util.Set;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;

public final class LanguageOptions
extends Options {
    private final Boolean multilingual;
    @Min(value=1L)
    private final Integer minValidChars;
    @Min(value=1L)
    private final Integer profileDepth;
    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    private final Double ambiguityThreshold;
    @DecimalMin(value="0.0")
    @DecimalMax(value="100.0")
    private final Double invalidityThreshold;
    private final LanguageCode languageHint;
    @DecimalMin(value="1.0")
    @DecimalMax(value="99.0")
    private final Double languageHintWeight;
    private final EncodingCode encodingHint;
    @DecimalMin(value="1.0")
    @DecimalMax(value="100.0")
    private final Double encodingHintWeight;
    private final Set<LanguageWeight> languageWeightAdjustments;
    private final Boolean koreanDialects;

    @ConstructorProperties(value={"multilingual", "minValidChars", "profileDepth", "ambiguityThreshold", "invalidityThreshold", "languageHint", "languageHintWeight", "encodingHint", "encodingHintWeight", "languageWeightAdjustments", "koreanDialects"})
    LanguageOptions(Boolean multilingual, Integer minValidChars, Integer profileDepth, Double ambiguityThreshold, Double invalidityThreshold, LanguageCode languageHint, Double languageHintWeight, EncodingCode encodingHint, Double encodingHintWeight, Set<LanguageWeight> languageWeightAdjustments, Boolean koreanDialects) {
        this.multilingual = multilingual;
        this.minValidChars = minValidChars;
        this.profileDepth = profileDepth;
        this.ambiguityThreshold = ambiguityThreshold;
        this.invalidityThreshold = invalidityThreshold;
        this.languageHint = languageHint;
        this.languageHintWeight = languageHintWeight;
        this.encodingHint = encodingHint;
        this.encodingHintWeight = encodingHintWeight;
        this.languageWeightAdjustments = languageWeightAdjustments;
        this.koreanDialects = koreanDialects;
    }

    public static LanguageOptionsBuilder builder() {
        return new LanguageOptionsBuilder();
    }

    public Boolean getMultilingual() {
        return this.multilingual;
    }

    public Integer getMinValidChars() {
        return this.minValidChars;
    }

    public Integer getProfileDepth() {
        return this.profileDepth;
    }

    public Double getAmbiguityThreshold() {
        return this.ambiguityThreshold;
    }

    public Double getInvalidityThreshold() {
        return this.invalidityThreshold;
    }

    public LanguageCode getLanguageHint() {
        return this.languageHint;
    }

    public Double getLanguageHintWeight() {
        return this.languageHintWeight;
    }

    public EncodingCode getEncodingHint() {
        return this.encodingHint;
    }

    public Double getEncodingHintWeight() {
        return this.encodingHintWeight;
    }

    public Set<LanguageWeight> getLanguageWeightAdjustments() {
        return this.languageWeightAdjustments;
    }

    public Boolean getKoreanDialects() {
        return this.koreanDialects;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LanguageOptions)) {
            return false;
        }
        LanguageOptions other = (LanguageOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$multilingual = this.getMultilingual();
        Boolean other$multilingual = other.getMultilingual();
        if (this$multilingual == null ? other$multilingual != null : !((Object)this$multilingual).equals(other$multilingual)) {
            return false;
        }
        Integer this$minValidChars = this.getMinValidChars();
        Integer other$minValidChars = other.getMinValidChars();
        if (this$minValidChars == null ? other$minValidChars != null : !((Object)this$minValidChars).equals(other$minValidChars)) {
            return false;
        }
        Integer this$profileDepth = this.getProfileDepth();
        Integer other$profileDepth = other.getProfileDepth();
        if (this$profileDepth == null ? other$profileDepth != null : !((Object)this$profileDepth).equals(other$profileDepth)) {
            return false;
        }
        Double this$ambiguityThreshold = this.getAmbiguityThreshold();
        Double other$ambiguityThreshold = other.getAmbiguityThreshold();
        if (this$ambiguityThreshold == null ? other$ambiguityThreshold != null : !((Object)this$ambiguityThreshold).equals(other$ambiguityThreshold)) {
            return false;
        }
        Double this$invalidityThreshold = this.getInvalidityThreshold();
        Double other$invalidityThreshold = other.getInvalidityThreshold();
        if (this$invalidityThreshold == null ? other$invalidityThreshold != null : !((Object)this$invalidityThreshold).equals(other$invalidityThreshold)) {
            return false;
        }
        LanguageCode this$languageHint = this.getLanguageHint();
        LanguageCode other$languageHint = other.getLanguageHint();
        if (this$languageHint == null ? other$languageHint != null : !this$languageHint.equals(other$languageHint)) {
            return false;
        }
        Double this$languageHintWeight = this.getLanguageHintWeight();
        Double other$languageHintWeight = other.getLanguageHintWeight();
        if (this$languageHintWeight == null ? other$languageHintWeight != null : !((Object)this$languageHintWeight).equals(other$languageHintWeight)) {
            return false;
        }
        EncodingCode this$encodingHint = this.getEncodingHint();
        EncodingCode other$encodingHint = other.getEncodingHint();
        if (this$encodingHint == null ? other$encodingHint != null : !this$encodingHint.equals(other$encodingHint)) {
            return false;
        }
        Double this$encodingHintWeight = this.getEncodingHintWeight();
        Double other$encodingHintWeight = other.getEncodingHintWeight();
        if (this$encodingHintWeight == null ? other$encodingHintWeight != null : !((Object)this$encodingHintWeight).equals(other$encodingHintWeight)) {
            return false;
        }
        Set<LanguageWeight> this$languageWeightAdjustments = this.getLanguageWeightAdjustments();
        Set<LanguageWeight> other$languageWeightAdjustments = other.getLanguageWeightAdjustments();
        if (this$languageWeightAdjustments == null ? other$languageWeightAdjustments != null : !((Object)this$languageWeightAdjustments).equals(other$languageWeightAdjustments)) {
            return false;
        }
        Boolean this$koreanDialects = this.getKoreanDialects();
        Boolean other$koreanDialects = other.getKoreanDialects();
        return !(this$koreanDialects == null ? other$koreanDialects != null : !((Object)this$koreanDialects).equals(other$koreanDialects));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LanguageOptions;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $multilingual = this.getMultilingual();
        result = result * 59 + ($multilingual == null ? 43 : ((Object)$multilingual).hashCode());
        Integer $minValidChars = this.getMinValidChars();
        result = result * 59 + ($minValidChars == null ? 43 : ((Object)$minValidChars).hashCode());
        Integer $profileDepth = this.getProfileDepth();
        result = result * 59 + ($profileDepth == null ? 43 : ((Object)$profileDepth).hashCode());
        Double $ambiguityThreshold = this.getAmbiguityThreshold();
        result = result * 59 + ($ambiguityThreshold == null ? 43 : ((Object)$ambiguityThreshold).hashCode());
        Double $invalidityThreshold = this.getInvalidityThreshold();
        result = result * 59 + ($invalidityThreshold == null ? 43 : ((Object)$invalidityThreshold).hashCode());
        LanguageCode $languageHint = this.getLanguageHint();
        result = result * 59 + ($languageHint == null ? 43 : $languageHint.hashCode());
        Double $languageHintWeight = this.getLanguageHintWeight();
        result = result * 59 + ($languageHintWeight == null ? 43 : ((Object)$languageHintWeight).hashCode());
        EncodingCode $encodingHint = this.getEncodingHint();
        result = result * 59 + ($encodingHint == null ? 43 : $encodingHint.hashCode());
        Double $encodingHintWeight = this.getEncodingHintWeight();
        result = result * 59 + ($encodingHintWeight == null ? 43 : ((Object)$encodingHintWeight).hashCode());
        Set<LanguageWeight> $languageWeightAdjustments = this.getLanguageWeightAdjustments();
        result = result * 59 + ($languageWeightAdjustments == null ? 43 : ((Object)$languageWeightAdjustments).hashCode());
        Boolean $koreanDialects = this.getKoreanDialects();
        result = result * 59 + ($koreanDialects == null ? 43 : ((Object)$koreanDialects).hashCode());
        return result;
    }

    public String toString() {
        return "LanguageOptions(multilingual=" + this.getMultilingual() + ", minValidChars=" + this.getMinValidChars() + ", profileDepth=" + this.getProfileDepth() + ", ambiguityThreshold=" + this.getAmbiguityThreshold() + ", invalidityThreshold=" + this.getInvalidityThreshold() + ", languageHint=" + this.getLanguageHint() + ", languageHintWeight=" + this.getLanguageHintWeight() + ", encodingHint=" + this.getEncodingHint() + ", encodingHintWeight=" + this.getEncodingHintWeight() + ", languageWeightAdjustments=" + this.getLanguageWeightAdjustments() + ", koreanDialects=" + this.getKoreanDialects() + ")";
    }

    public static class LanguageOptionsBuilder {
        private Boolean multilingual;
        private Integer minValidChars;
        private Integer profileDepth;
        private Double ambiguityThreshold;
        private Double invalidityThreshold;
        private LanguageCode languageHint;
        private Double languageHintWeight;
        private EncodingCode encodingHint;
        private Double encodingHintWeight;
        private Set<LanguageWeight> languageWeightAdjustments;
        private Boolean koreanDialects;

        LanguageOptionsBuilder() {
        }

        public LanguageOptionsBuilder multilingual(Boolean multilingual) {
            this.multilingual = multilingual;
            return this;
        }

        public LanguageOptionsBuilder minValidChars(Integer minValidChars) {
            this.minValidChars = minValidChars;
            return this;
        }

        public LanguageOptionsBuilder profileDepth(Integer profileDepth) {
            this.profileDepth = profileDepth;
            return this;
        }

        public LanguageOptionsBuilder ambiguityThreshold(Double ambiguityThreshold) {
            this.ambiguityThreshold = ambiguityThreshold;
            return this;
        }

        public LanguageOptionsBuilder invalidityThreshold(Double invalidityThreshold) {
            this.invalidityThreshold = invalidityThreshold;
            return this;
        }

        public LanguageOptionsBuilder languageHint(LanguageCode languageHint) {
            this.languageHint = languageHint;
            return this;
        }

        public LanguageOptionsBuilder languageHintWeight(Double languageHintWeight) {
            this.languageHintWeight = languageHintWeight;
            return this;
        }

        public LanguageOptionsBuilder encodingHint(EncodingCode encodingHint) {
            this.encodingHint = encodingHint;
            return this;
        }

        public LanguageOptionsBuilder encodingHintWeight(Double encodingHintWeight) {
            this.encodingHintWeight = encodingHintWeight;
            return this;
        }

        public LanguageOptionsBuilder languageWeightAdjustments(Set<LanguageWeight> languageWeightAdjustments) {
            this.languageWeightAdjustments = languageWeightAdjustments;
            return this;
        }

        public LanguageOptionsBuilder koreanDialects(Boolean koreanDialects) {
            this.koreanDialects = koreanDialects;
            return this;
        }

        public LanguageOptions build() {
            return new LanguageOptions(this.multilingual, this.minValidChars, this.profileDepth, this.ambiguityThreshold, this.invalidityThreshold, this.languageHint, this.languageHintWeight, this.encodingHint, this.encodingHintWeight, this.languageWeightAdjustments, this.koreanDialects);
        }

        public String toString() {
            return "LanguageOptions.LanguageOptionsBuilder(multilingual=" + this.multilingual + ", minValidChars=" + this.minValidChars + ", profileDepth=" + this.profileDepth + ", ambiguityThreshold=" + this.ambiguityThreshold + ", invalidityThreshold=" + this.invalidityThreshold + ", languageHint=" + this.languageHint + ", languageHintWeight=" + this.languageHintWeight + ", encodingHint=" + this.encodingHint + ", encodingHintWeight=" + this.encodingHintWeight + ", languageWeightAdjustments=" + this.languageWeightAdjustments + ", koreanDialects=" + this.koreanDialects + ")";
        }
    }
}

