/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.basistech.rosette.dm.ListAttribute;
import com.basistech.rosette.dm.jackson.KnownAttribute;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.util.Map;

public class ListAttributeSerializer
extends JsonSerializer<ListAttribute> {
    public void serialize(ListAttribute value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("itemType", KnownAttribute.getAttributeForClass(value.getItemClass()).key());
        jgen.writeObjectField("items", (Object)value.getItems());
        this.writeExtendedProperties(value, jgen);
        jgen.writeEndObject();
    }

    private void writeExtendedProperties(ListAttribute value, JsonGenerator jgen) throws IOException {
        Map extendedProperties = value.getExtendedProperties();
        if (extendedProperties != null && !extendedProperties.isEmpty()) {
            for (Map.Entry entry : extendedProperties.entrySet()) {
                jgen.writeObjectField((String)entry.getKey(), entry.getValue());
            }
        }
    }

    public void serializeWithType(ListAttribute value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForObject((Object)value, jgen);
        KnownAttribute attributeForClass = KnownAttribute.getAttributeForClass(value.getItemClass());
        assert (attributeForClass != null);
        jgen.writeStringField("itemType", attributeForClass.key());
        jgen.writeObjectField("items", (Object)value.getItems());
        this.writeExtendedProperties(value, jgen);
        typeSer.writeTypeSuffixForObject((Object)value, jgen);
    }
}

