/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.basistech.rosette.dm.ArabicMorphoAnalysis;
import com.basistech.rosette.dm.HanMorphoAnalysis;
import com.basistech.rosette.dm.KoreanMorphoAnalysis;
import com.basistech.rosette.dm.MorphoAnalysis;
import com.basistech.rosette.dm.Token;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MorphoAnalysisListDeserializer
extends JsonDeserializer<List<MorphoAnalysis>>
implements ContextualDeserializer {
    private static final Set<String> ARABIC_FIELDS;
    private final boolean cached;
    private final JsonDeserializer<Object> maDeserializer;
    private final JsonDeserializer<Object> hanMaDeserializer;
    private final JsonDeserializer<Object> arMaDeserializer;
    private final JsonDeserializer<Object> korMaDeserializer;

    public MorphoAnalysisListDeserializer() {
        this.cached = false;
        this.maDeserializer = null;
        this.hanMaDeserializer = null;
        this.arMaDeserializer = null;
        this.korMaDeserializer = null;
    }

    private MorphoAnalysisListDeserializer(DeserializationContext ctxt) throws JsonMappingException {
        JavaType type = ctxt.constructType(MorphoAnalysis.class);
        this.maDeserializer = ctxt.findRootValueDeserializer(type);
        type = ctxt.constructType(HanMorphoAnalysis.class);
        this.hanMaDeserializer = ctxt.findRootValueDeserializer(type);
        type = ctxt.constructType(ArabicMorphoAnalysis.class);
        this.arMaDeserializer = ctxt.findRootValueDeserializer(type);
        ctxt.setAttribute(MorphoAnalysisListDeserializer.class, this.maDeserializer);
        type = ctxt.constructType(KoreanMorphoAnalysis.class);
        this.korMaDeserializer = ctxt.findRootValueDeserializer(type);
        ctxt.setAttribute(KoreanMorphoAnalysis.class, this.korMaDeserializer);
        this.cached = true;
    }

    private boolean anyArabicFields(Set<String> fields) {
        for (String field : fields) {
            if (!ARABIC_FIELDS.contains(field)) continue;
            return true;
        }
        return false;
    }

    private JsonDeserializer<Object> castDeserializer(Object attributeValue) {
        return (JsonDeserializer)attributeValue;
    }

    public List<MorphoAnalysis> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (!this.cached) {
            throw new JsonMappingException((Closeable)jp, "attempt to deserialize with un-contextualized MorphoAnalysisListDeserializer");
        }
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "Expected array of items");
        }
        JsonDeserializer<Object> currentDeserializer = this.castDeserializer(ctxt.getAttribute(MorphoAnalysisListDeserializer.class));
        if (currentDeserializer == null) {
            currentDeserializer = this.maDeserializer;
            ctxt.setAttribute(MorphoAnalysisListDeserializer.class, this.maDeserializer);
        }
        ArrayList result = Lists.newArrayList();
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            MorphoAnalysis analysis = (MorphoAnalysis)currentDeserializer.deserialize(jp, ctxt);
            if (analysis.getExtendedProperties().size() != 0) {
                KoreanMorphoAnalysis.Builder builder;
                if (analysis.getExtendedProperties().containsKey("morphemes")) {
                    builder = new KoreanMorphoAnalysis.Builder();
                    this.copyBasic(analysis, (MorphoAnalysis.Builder)builder);
                    Iterator morphemes = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("morphemes"));
                    List<String> morphemeTags = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("morphemeTags"));
                    for (int x = 0; x < morphemes.size(); ++x) {
                        builder.addMorpheme((String)morphemes.get(x), morphemeTags.get(x));
                    }
                    for (Map.Entry me : analysis.getExtendedProperties().entrySet()) {
                        if ("morphemes".equals(me.getKey()) || "morphemeTags".equals(me.getKey())) continue;
                        builder.extendedProperty((String)me.getKey(), me.getValue());
                    }
                    analysis = builder.build();
                    ctxt.setAttribute(MorphoAnalysisListDeserializer.class, this.korMaDeserializer);
                } else if (analysis.getExtendedProperties().containsKey("readings")) {
                    builder = new HanMorphoAnalysis.Builder();
                    this.copyBasic(analysis, (MorphoAnalysis.Builder)builder);
                    for (String reading : MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("readings"))) {
                        builder.addReading(reading);
                    }
                    for (Map.Entry me : analysis.getExtendedProperties().entrySet()) {
                        if ("readings".equals(me.getKey())) continue;
                        builder.extendedProperty((String)me.getKey(), me.getValue());
                    }
                    analysis = builder.build();
                    ctxt.setAttribute(MorphoAnalysisListDeserializer.class, this.hanMaDeserializer);
                } else if (this.anyArabicFields(analysis.getExtendedProperties().keySet())) {
                    List<String> suffixes;
                    List<String> stems;
                    List<String> prefixes;
                    Boolean strippablePrefix;
                    Boolean definiteArticle;
                    String root;
                    builder = new ArabicMorphoAnalysis.Builder();
                    this.copyBasic(analysis, (MorphoAnalysis.Builder)builder);
                    Integer prefixLength = (Integer)analysis.getExtendedProperties().get("prefixLength");
                    Integer stemLength = (Integer)analysis.getExtendedProperties().get("stemLength");
                    if (prefixLength != null && stemLength != null) {
                        builder.lengths(prefixLength.intValue(), stemLength.intValue());
                    }
                    if ((root = (String)analysis.getExtendedProperties().get("root")) != null) {
                        builder.root(root);
                    }
                    if ((definiteArticle = (Boolean)analysis.getExtendedProperties().get("definiteArticle")) != null) {
                        builder.definiteArticle(definiteArticle.booleanValue());
                    }
                    if ((strippablePrefix = (Boolean)analysis.getExtendedProperties().get("strippablePrefix")) != null) {
                        builder.strippablePrefix(strippablePrefix.booleanValue());
                    }
                    if ((prefixes = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("prefixes"))) != null) {
                        List<String> prefixTags = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("prefixTags"));
                        for (int x = 0; x < prefixes.size(); ++x) {
                            builder.addPrefix(prefixes.get(x), prefixTags.get(x));
                        }
                    }
                    if ((stems = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("stems"))) != null) {
                        List<String> stemTags = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("stemTags"));
                        for (int x = 0; x < stems.size(); ++x) {
                            builder.addStem(stems.get(x), stemTags.get(x));
                        }
                    }
                    if ((suffixes = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("suffixes"))) != null) {
                        List<String> suffixTags = MorphoAnalysisListDeserializer.cast(analysis.getExtendedProperties().get("suffixTags"));
                        for (int x = 0; x < suffixes.size(); ++x) {
                            builder.addSuffix(suffixes.get(x), suffixTags.get(x));
                        }
                    }
                    for (Map.Entry me : analysis.getExtendedProperties().entrySet()) {
                        if (ARABIC_FIELDS.contains(me.getKey())) continue;
                        builder.extendedProperty((String)me.getKey(), me.getValue());
                    }
                    analysis = builder.build();
                    ctxt.setAttribute(MorphoAnalysisListDeserializer.class, this.arMaDeserializer);
                }
            }
            result.add(analysis);
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private void copyBasic(MorphoAnalysis analysis, MorphoAnalysis.Builder builder) {
        if (analysis.getLemma() != null && !"".equals(analysis.getLemma())) {
            builder.lemma(analysis.getLemma());
        }
        if (analysis.getPartOfSpeech() != null && !"".equals(analysis.getPartOfSpeech())) {
            builder.partOfSpeech(analysis.getPartOfSpeech());
        }
        if (analysis.getRaw() != null && !"".equals(analysis.getRaw())) {
            builder.raw(analysis.getRaw());
        }
        if (analysis.getComponents() != null) {
            for (Token token : analysis.getComponents()) {
                builder.addComponent(token);
            }
        }
    }

    private static List<String> cast(Object object) {
        return (List)object;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        if (this.cached) {
            return this;
        }
        return new MorphoAnalysisListDeserializer(ctxt);
    }

    static {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (Field field : ArabicMorphoAnalysis.class.getDeclaredFields()) {
            try {
                MorphoAnalysis.class.getDeclaredField(field.getName());
            }
            catch (NoSuchFieldException e) {
                builder.add((Object)field.getName());
            }
        }
        ARABIC_FIELDS = builder.build();
    }
}

