/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.basistech.rosette.dm.Transliteration;
import com.basistech.util.ISO15924;
import com.basistech.util.LanguageCode;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TransliterationResultsDeserializer
extends JsonDeserializer<Map<LanguageCode, Transliteration>> {
    private static final TypeReference<Map<String, Map<ISO15924, String>>> REF = new TypeReference<Map<String, Map<ISO15924, String>>>(){};

    public Map<LanguageCode, Transliteration> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Map val = (Map)p.readValueAs(REF);
        HashMap<LanguageCode, Transliteration> output = new HashMap<LanguageCode, Transliteration>();
        for (Map.Entry entry : val.entrySet()) {
            Transliteration.Builder b = new Transliteration.Builder();
            b.transliterations((Map)entry.getValue());
            output.put(LanguageCode.lookupByISO639((String)((String)entry.getKey())), b.build());
        }
        return output;
    }
}

