/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public class VersionCheckDeserializer
extends JsonDeserializer<String> {
    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw ctxt.wrongTokenException(p, JsonToken.VALUE_STRING, "The value of 'version' must be a string");
        }
        String version = (String)p.readValueAs(String.class);
        String[] bits = version.split("\\.");
        if (bits.length < 3) {
            throw ctxt.weirdStringException(version, String.class, "Versions must be of the form x.y.z");
        }
        if (!"1".equals(bits[0])) {
            throw ctxt.weirdStringException(version, String.class, String.format("Incompatible ADM version %s", version));
        }
        return version;
    }
}

