/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.dm.jackson.array;

import com.basistech.rosette.dm.BaseAttribute;
import com.basistech.rosette.dm.ListAttribute;
import com.basistech.rosette.dm.jackson.KnownAttribute;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ListAttributeArrayDeserializer
extends JsonDeserializer<ListAttribute> {
    public ListAttribute deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp.getCurrentToken() != JsonToken.START_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "ListAttributeDeserializer called not array start.");
        }
        jp.nextToken();
        if (jp.getCurrentToken() != JsonToken.VALUE_STRING) {
            throw ctxt.mappingException("Expected VALUE_STRING for item type.");
        }
        String itemTypeKeyName = jp.getText();
        KnownAttribute attribute = KnownAttribute.getAttributeForKey(itemTypeKeyName);
        if (attribute == null) {
            attribute = KnownAttribute.UNKNOWN;
        }
        Class<? extends BaseAttribute> itemClass = attribute.attributeClass();
        ListAttribute.Builder builder = new ListAttribute.Builder(attribute.attributeClass());
        ArrayList items = Lists.newArrayList();
        if (jp.nextToken() != JsonToken.START_ARRAY) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_ARRAY, "No array of values for list.");
        }
        while (jp.nextToken() != JsonToken.END_ARRAY) {
            items.add(jp.readValueAs(itemClass));
        }
        builder.setItems((List)items);
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw ctxt.wrongTokenException(jp, JsonToken.START_OBJECT, "No extended properties for list.");
        }
        Map props = (Map)jp.readValueAs((TypeReference)new TypeReference<Map<String, Object>>(){});
        for (Map.Entry me : props.entrySet()) {
            builder.extendedProperty((String)me.getKey(), me.getValue());
        }
        jp.nextToken();
        return builder.build();
    }
}

