/*
 * Decompiled with CFR 0.152.
 */
package com.basistech.rosette.examples;

import com.basistech.rosette.api.HttpRosetteAPI;
import com.basistech.rosette.apimodel.DocumentRequest;
import com.basistech.rosette.apimodel.Request;
import com.basistech.rosette.apimodel.Response;
import com.basistech.rosette.apimodel.SentimentResponse;
import com.basistech.rosette.examples.ExampleBase;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public final class SentimentExample
extends ExampleBase {
    public static void main(String[] args) {
        try {
            new SentimentExample().run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void run() throws IOException {
        String sentimentFileData = "<html><head><title>New Ghostbusters Film</title></head><body><p>Original Ghostbuster Dan Aykroyd, who also co-wrote the 1984 Ghostbusters film, couldn\u2019t be more pleased with the new all-female Ghostbusters cast, telling The Hollywood Reporter, \u201cThe Aykroyd family is delighted by this inheritance of the Ghostbusters torch by these most magnificent women in comedy.\u201d</p></body></html>";
        try (InputStream inputStream = Files.newInputStream(SentimentExample.createTempDataFile(sentimentFileData), new OpenOption[0]);){
            HttpRosetteAPI rosetteApi = new HttpRosetteAPI.Builder().key(this.getApiKeyFromSystemProperty()).url(this.getAltUrlFromSystemProperty()).build();
            DocumentRequest request = DocumentRequest.builder().content(inputStream, "text/html").build();
            SentimentResponse response = (SentimentResponse)rosetteApi.perform("/sentiment", (Request)request, SentimentResponse.class);
            System.out.println(SentimentExample.responseToJson((Response)response));
        }
    }

    private static Path createTempDataFile(String data) throws IOException {
        Path file = Files.createTempFile("example.", ".html", new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(data);
        }
        file.toFile().deleteOnExit();
        return file;
    }
}

